/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.inventory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.inventory.ContainerData;

public class CombinedContainerData
implements ContainerData {
    private final int dataCount;
    private final ContainerData[] backingData;
    private final Map<Integer, Integer> backingDataIndexLookup;
    private final Map<Integer, Integer> dataOffsetIndexLookup;

    public CombinedContainerData(ContainerData ... backingData) {
        this.backingData = Arrays.copyOf(backingData, backingData.length);
        this.backingDataIndexLookup = new HashMap<Integer, Integer>();
        this.dataOffsetIndexLookup = new HashMap<Integer, Integer>();
        int dataIndex = 0;
        for (int i = 0; i < backingData.length; ++i) {
            int dataCount = backingData[i].getCount();
            for (int j = 0; j < dataCount; ++j) {
                this.backingDataIndexLookup.put(dataIndex + j, i);
                this.dataOffsetIndexLookup.put(dataIndex + j, dataIndex);
            }
            dataIndex += dataCount;
        }
        this.dataCount = dataIndex;
    }

    public int get(int index) {
        Integer backingDataIndex = this.backingDataIndexLookup.get(index);
        if (backingDataIndex == null) {
            return 0;
        }
        int dataOffsetIndex = this.dataOffsetIndexLookup.get(index);
        return this.backingData[backingDataIndex].get(index - dataOffsetIndex);
    }

    public void set(int index, int value) {
        Integer backingDataIndex = this.backingDataIndexLookup.get(index);
        if (backingDataIndex == null) {
            return;
        }
        int dataOffsetIndex = this.dataOffsetIndexLookup.get(index);
        this.backingData[backingDataIndex].set(index - dataOffsetIndex, value);
    }

    public int getCount() {
        return this.dataCount;
    }
}

