/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.rei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.ChargerBlockEntity;
import me.jddev0.ep.integration.rei.ChargerDisplay;
import me.jddev0.ep.recipe.ChargerRecipe;
import me.jddev0.ep.util.EnergyUtils;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public class ChargerCategory
implements DisplayCategory<ChargerDisplay> {
    public static final CategoryIdentifier<ChargerDisplay> CATEGORY = CategoryIdentifier.of((String)"energizedpower", (String)"charger");
    private static final int PADDING = 5;

    public CategoryIdentifier<? extends ChargerDisplay> getCategoryIdentifier() {
        return CATEGORY;
    }

    public Component getTitle() {
        return Component.translatable((String)"container.energizedpower.charger");
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)EPBlocks.CHARGER_ITEM.get()));
    }

    public List<Widget> setupDisplay(ChargerDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        int x = bounds.x + 5;
        int y = bounds.y + 5;
        ResourceLocation texture = EPAPI.id("textures/gui/container/charger.png");
        widgets.add(Widgets.createTexturedWidget((ResourceLocation)texture, (int)x, (int)y, (float)65.0f, (float)20.0f, (int)46, (int)46));
        widgets.add((Widget)Widgets.createArrow((Point)new Point(x + 55, y + 15)));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(x + 92, y + 15)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(x + 15, y + 15)).disableBackground().markInput().entries((Collection)display.getInputEntries().get(0)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(x + 92, y + 15)).disableBackground().markOutput().entries((Collection)display.getOutputEntries().get(0)));
        int energyConsumption = (int)((float)((ChargerRecipe)display.recipe().value()).getEnergyConsumption() * ChargerBlockEntity.CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER);
        widgets.add((Widget)Widgets.createLabel((Point)new Point(x + bounds.width - 10, y + bounds.height - 17), (Component)Component.literal((String)EnergyUtils.getEnergyWithPrefix(energyConsumption)).withStyle(ChatFormatting.YELLOW)).noShadow().rightAligned());
        return widgets;
    }

    public int getDisplayWidth(ChargerDisplay display) {
        return 123;
    }

    public int getDisplayHeight() {
        return 56;
    }
}

