/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.PlantGrowthChamberFertilizerRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class PlantGrowthChamberFertilizerCategory
implements IRecipeCategory<RecipeHolder<PlantGrowthChamberFertilizerRecipe>> {
    public static final RecipeType<RecipeHolder<PlantGrowthChamberFertilizerRecipe>> TYPE = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)PlantGrowthChamberFertilizerRecipe.Type.INSTANCE);
    private final IDrawable background;
    private final IDrawable fertlizerSlot;
    private final IDrawable icon;

    public PlantGrowthChamberFertilizerCategory(IGuiHelper helper) {
        ResourceLocation texture = EPAPI.id("textures/gui/container/plant_growth_chamber.png");
        this.fertlizerSlot = helper.createDrawable(texture, 34, 34, 18, 18);
        this.background = helper.createBlankDrawable(144, 30);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EPBlocks.PLANT_GROWTH_CHAMBER_ITEM.get()));
    }

    public RecipeType<RecipeHolder<PlantGrowthChamberFertilizerRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"recipes.energizedpower.plant_growth_chamber_fertilizer");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayoutBuilder, RecipeHolder<PlantGrowthChamberFertilizerRecipe> recipe, IFocusGroup iFocusGroup) {
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(((PlantGrowthChamberFertilizerRecipe)recipe.value()).getInput());
    }

    public void draw(RecipeHolder<PlantGrowthChamberFertilizerRecipe> recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.fertlizerSlot.draw(guiGraphics, 0, 0);
        Font font = Minecraft.getInstance().font;
        MutableComponent component = Component.translatable((String)"recipes.energizedpower.plant_growth_chamber_fertilizer.speed_multiplier", (Object[])new Object[]{((PlantGrowthChamberFertilizerRecipe)recipe.value()).getSpeedMultiplier()});
        int textWidth = font.width((FormattedText)component);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)component, 144 - textWidth, 5, -1, false);
        component = Component.translatable((String)"recipes.energizedpower.plant_growth_chamber_fertilizer.energy_consumption_multiplier", (Object[])new Object[]{((PlantGrowthChamberFertilizerRecipe)recipe.value()).getEnergyConsumptionMultiplier()});
        textWidth = font.width((FormattedText)component);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)component, 144 - textWidth, 22, -1, false);
    }
}

