/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.CrystalGrowthChamberBlockEntity;
import me.jddev0.ep.recipe.CrystalGrowthChamberRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class CrystalGrowthChamberCategory
implements IRecipeCategory<RecipeHolder<CrystalGrowthChamberRecipe>> {
    public static final RecipeType<RecipeHolder<CrystalGrowthChamberRecipe>> TYPE = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)CrystalGrowthChamberRecipe.Type.INSTANCE);
    private final IDrawable background;
    private final IDrawable icon;

    public CrystalGrowthChamberCategory(IGuiHelper helper) {
        ResourceLocation texture = EPAPI.id("textures/gui/container/crystal_growth_chamber.png");
        this.background = helper.createDrawable(texture, 47, 30, 98, 38);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EPBlocks.CRYSTAL_GROWTH_CHAMBER_ITEM.get()));
    }

    public RecipeType<RecipeHolder<CrystalGrowthChamberRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"container.energizedpower.crystal_growth_chamber");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayoutBuilder, RecipeHolder<CrystalGrowthChamberRecipe> recipe, IFocusGroup iFocusGroup) {
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 1, 5).addItemStacks(Arrays.stream(((CrystalGrowthChamberRecipe)recipe.value()).getInput().getItems()).map(itemStack -> itemStack.copyWithCount(((CrystalGrowthChamberRecipe)recipe.value()).getInputCount())).collect(Collectors.toList()));
        ((IRecipeSlotBuilder)iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 77, 5).addItemStack(((CrystalGrowthChamberRecipe)recipe.value()).getMaxOutputCount())).addRichTooltipCallback((view, tooltip) -> {
            tooltip.add((FormattedText)Component.translatable((String)"recipes.energizedpower.transfer.output_percentages"));
            double[] percentages = ((CrystalGrowthChamberRecipe)recipe.value()).getOutput().percentages();
            for (int i = 0; i < percentages.length; ++i) {
                tooltip.add((FormattedText)Component.literal((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages[i])));
            }
        });
    }

    public void draw(RecipeHolder<CrystalGrowthChamberRecipe> recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.getInstance().font;
        int ticks = (int)((float)((CrystalGrowthChamberRecipe)recipe.value()).getTicks() * CrystalGrowthChamberBlockEntity.RECIPE_DURATION_MULTIPLIER);
        MutableComponent component = Component.translatable((String)"recipes.energizedpower.info.ticks", (Object[])new Object[]{ticks});
        int textWidth = font.width((FormattedText)component);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)component, 98 - textWidth, 30, -1, false);
    }
}

