/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.CrystalGrowthChamberBlockEntity;
import me.jddev0.ep.recipe.CrystalGrowthChamberRecipe;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class CrystalGrowthChamberEMIRecipe
implements EmiRecipe {
    public static final ResourceLocation SIMPLIFIED_TEXTURE = EPAPI.id("textures/block/crystal_growth_chamber_side.png");
    public static final EmiStack ITEM = EmiStack.of((ItemLike)((ItemLike)EPBlocks.CRYSTAL_GROWTH_CHAMBER_ITEM.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(EPAPI.id("crystal_growth_chamber"), (EmiRenderable)ITEM, (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURE, 0, 0, 16, 16, 16, 16, 16, 16));
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final OutputItemStackWithPercentages outputWithPercentages;
    private final int ticks;

    public CrystalGrowthChamberEMIRecipe(RecipeHolder<CrystalGrowthChamberRecipe> recipe) {
        this.id = recipe.id();
        this.input = List.of(EmiIngredient.of((Ingredient)((CrystalGrowthChamberRecipe)recipe.value()).getInput(), (long)((CrystalGrowthChamberRecipe)recipe.value()).getInputCount()));
        this.output = List.of(EmiStack.of((ItemStack)((CrystalGrowthChamberRecipe)recipe.value()).getMaxOutputCount()));
        this.outputWithPercentages = ((CrystalGrowthChamberRecipe)recipe.value()).getOutput();
        this.ticks = (int)((float)((CrystalGrowthChamberRecipe)recipe.value()).getTicks() * CrystalGrowthChamberBlockEntity.RECIPE_DURATION_MULTIPLIER);
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 98;
    }

    public int getDisplayHeight() {
        return 38;
    }

    public void addWidgets(WidgetHolder widgets) {
        ResourceLocation texture = EPAPI.id("textures/gui/container/crystal_growth_chamber.png");
        widgets.addTexture(texture, 0, 0, 98, 38, 47, 30);
        widgets.addSlot(this.input.get(0), 0, 4).drawBack(false);
        SlotWidget outputSlot = widgets.addSlot((EmiIngredient)this.output.get(0), 76, 4).drawBack(false).recipeContext((EmiRecipe)this);
        outputSlot.appendTooltip((Component)Component.translatable((String)"recipes.energizedpower.transfer.output_percentages"));
        double[] percentages = this.outputWithPercentages.percentages();
        for (int i = 0; i < percentages.length; ++i) {
            outputSlot.appendTooltip((Component)Component.literal((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages[i])));
        }
        MutableComponent ticksText = Component.translatable((String)"recipes.energizedpower.info.ticks", (Object[])new Object[]{this.ticks});
        FormattedCharSequence formattedCharSequence = ticksText.getVisualOrderText();
        int n = widgets.getWidth() - Minecraft.getInstance().font.width((FormattedText)ticksText);
        int n2 = widgets.getHeight();
        Objects.requireNonNull(Minecraft.getInstance().font);
        widgets.addText(formattedCharSequence, n, n2 - 9, ChatFormatting.WHITE.getColor().intValue(), false);
    }
}

