/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.curios;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public final class CuriosCompatUtils {
    private CuriosCompatUtils() {
    }

    public static boolean isCuriosAvailable() {
        try {
            Class.forName("top.theillusivec4.curios.api.CuriosApi");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static List<ItemStack> getCuriosItemStacks(Inventory inventory) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (!CuriosCompatUtils.isCuriosAvailable()) {
            return itemStacks;
        }
        Optional<IItemHandlerModifiable> itemHandlerModifiableLazyOptional = CuriosApi.getCuriosInventory((LivingEntity)inventory.player).map(ICuriosItemHandler::getEquippedCurios);
        if (itemHandlerModifiableLazyOptional.isEmpty()) {
            return itemStacks;
        }
        IItemHandlerModifiable itemHandlerModifiable = itemHandlerModifiableLazyOptional.orElseGet(null);
        for (int i = 0; i < itemHandlerModifiable.getSlots(); ++i) {
            ItemStack itemStack = itemHandlerModifiable.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            itemStacks.add(itemStack);
        }
        return itemStacks;
    }
}

