/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.datagen.generators;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import me.jddev0.ep.datagen.generators.PageContent;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public abstract class PageContentProvider
implements DataProvider {
    private final Map<String, PageContent> data = new TreeMap<String, PageContent>();
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final String modid;
    private final ExistingFileHelper existingFileHelper;

    public PageContentProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modid, ExistingFileHelper existingFileHelper) {
        this.output = output;
        this.lookupProvider = lookupProvider;
        this.modid = modid;
        this.existingFileHelper = existingFileHelper;
    }

    protected abstract void registerPageContent();

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.lookupProvider.thenCompose(lookupProvider -> this.run(cache, (HolderLookup.Provider)lookupProvider));
    }

    private CompletableFuture<?> run(CachedOutput cache, HolderLookup.Provider lookupProvider) {
        this.data.clear();
        this.registerPageContent();
        CompletableFuture[] futures = new CompletableFuture[this.data.size()];
        int i = 0;
        for (Map.Entry<String, PageContent> entry : this.data.entrySet()) {
            futures[i++] = this.savePageContent(cache, entry.getKey(), entry.getValue(), lookupProvider);
        }
        return CompletableFuture.allOf(futures);
    }

    private CompletableFuture<?> savePageContent(CachedOutput cache, String pageId, PageContent content, HolderLookup.Provider lookupProvider) {
        Path target = this.output.getOutputFolder(PackOutput.Target.RESOURCE_PACK).resolve(this.modid).resolve("book_pages").resolve(pageId + ".json");
        JsonObject json = ((JsonElement)PageContent.CODEC.stable().encode((Object)content, (DynamicOps)lookupProvider.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)new JsonObject()).getOrThrow()).getAsJsonObject();
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)target);
    }

    public String getName() {
        return "Book Pages: " + this.modid;
    }

    protected MutableComponent addLinkToComponent(MutableComponent component, String link) {
        return component.withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE}).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, link)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"book.energizedpower.tooltip.link"))));
    }

    protected PageContent addSimplePage(String pageId, @Nullable Component content) {
        return this.addPage(pageId, null, content, null, null);
    }

    protected PageContent addSimplePage(String pageId, @Nullable Component content, @Nullable ResourceLocation image) {
        ResourceLocation[] resourceLocationArray;
        if (image == null) {
            resourceLocationArray = null;
        } else {
            ResourceLocation[] resourceLocationArray2 = new ResourceLocation[1];
            resourceLocationArray = resourceLocationArray2;
            resourceLocationArray2[0] = image;
        }
        return this.addPage(pageId, null, content, resourceLocationArray, null);
    }

    protected PageContent addSimplePage(String pageId, @Nullable Component content, @Nullable ResourceLocation[] image) {
        return this.addPage(pageId, null, content, image, null);
    }

    protected PageContent addSimplePage(String pageId, @Nullable Component content, Block block) {
        return this.addSimplePage(pageId, content, new Block[]{block});
    }

    protected PageContent addSimplePage(String pageId, @Nullable Component content, Block[] block) {
        ResourceLocation[] blockIds = new ResourceLocation[block.length];
        for (int i = 0; i < blockIds.length; ++i) {
            blockIds[i] = BuiltInRegistries.BLOCK.getKey((Object)block[i]);
        }
        return this.addPage(pageId, null, content, null, blockIds);
    }

    protected PageContent addChapterPage(String pageId, @Nullable Component title, @Nullable Component content, Block block) {
        return this.addChapterPage(pageId, title, content, new Block[]{block});
    }

    protected PageContent addChapterPage(String pageId, @Nullable Component title, @Nullable Component content, Block[] block) {
        ResourceLocation[] blockIds = new ResourceLocation[block.length];
        for (int i = 0; i < blockIds.length; ++i) {
            blockIds[i] = BuiltInRegistries.BLOCK.getKey((Object)block[i]);
        }
        return this.addPage(pageId, title, content, null, blockIds);
    }

    protected PageContent addChapterPage(String pageId, @Nullable Component title, @Nullable Component content) {
        return this.addChapterPage(pageId, title, content, (ResourceLocation[])null);
    }

    protected PageContent addChapterPage(String pageId, @Nullable Component title, @Nullable Component content, @Nullable ResourceLocation image) {
        ResourceLocation[] resourceLocationArray;
        if (image == null) {
            resourceLocationArray = null;
        } else {
            ResourceLocation[] resourceLocationArray2 = new ResourceLocation[1];
            resourceLocationArray = resourceLocationArray2;
            resourceLocationArray2[0] = image;
        }
        return this.addPage(pageId, title, content, resourceLocationArray, null);
    }

    protected PageContent addChapterPage(String pageId, @Nullable Component title, @Nullable Component content, @Nullable ResourceLocation[] image) {
        return this.addPage(pageId, title, content, image, null);
    }

    protected PageContent addPage(String pageId, @Nullable Component title, @Nullable Component content, @Nullable ResourceLocation[] image, @Nullable ResourceLocation[] block) {
        PageContent pageContent = new PageContent(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)pageId), title, content, image, block);
        this.data.put(pageId, pageContent);
        return pageContent;
    }
}

