/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.datagen;

import java.util.Objects;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.AlloyFurnaceBlock;
import me.jddev0.ep.block.CableBlock;
import me.jddev0.ep.block.ChargingStationBlock;
import me.jddev0.ep.block.ConfigurableTransformerBlock;
import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.EnergizerBlock;
import me.jddev0.ep.block.FluidPipeBlock;
import me.jddev0.ep.block.FluidTankBlock;
import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.ItemConveyorBeltSwitchBlock;
import me.jddev0.ep.block.LightningGeneratorBlock;
import me.jddev0.ep.block.TeleporterBlock;
import me.jddev0.ep.block.TransformerBlock;
import me.jddev0.ep.machine.tier.TransformerTier;
import me.jddev0.ep.machine.tier.TransformerType;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ModBlockStateProvider
extends BlockStateProvider {
    private ModelFile itemConveyorBeltFlatTemplate;
    private ModelFile itemConveyorBeltAscendingTemplate;
    private ModelFile itemConveyorBeltDescendingTemplate;
    private ModelFile fluidPipeCoreTemplate;
    private ModelFile fluidPipeSideConnectedTemplate;
    private ModelFile fluidPipeSideExtractTemplate;
    private ModelFile fluidTankTemplate;
    private ModelFile cableCoreTemplate;
    private ModelFile cableSideTemplate;
    private ModelFile solarPanelTemplate;
    private ModelFile singleSideTemplate;

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "energizedpower", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerTemplates();
        this.registerBlocks();
    }

    private void registerTemplates() {
        this.itemConveyorBeltFlatTemplate = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("item_conveyor_belt_flat_template")).ao(false)).element().from(0.0f, 1.0f, 0.0f).to(16.0f, 1.0f, 16.0f).face(Direction.DOWN).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#belt").end().face(Direction.UP).uvs(16.0f, 16.0f, 0.0f, 0.0f).texture("#belt").end().end();
        this.itemConveyorBeltAscendingTemplate = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("item_conveyor_belt_ascending_template")).ao(false)).element().from(0.0f, 9.0f, 0.0f).to(16.0f, 9.0f, 16.0f).rotation().origin(8.0f, 9.0f, 8.0f).axis(Direction.Axis.X).angle(-45.0f).rescale(true).end().face(Direction.DOWN).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#belt").end().face(Direction.UP).uvs(16.0f, 16.0f, 0.0f, 0.0f).texture("#belt").end().end();
        this.itemConveyorBeltDescendingTemplate = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("item_conveyor_belt_descending_template")).ao(false)).element().from(0.0f, 9.0f, 0.0f).to(16.0f, 9.0f, 16.0f).rotation().origin(8.0f, 9.0f, 8.0f).axis(Direction.Axis.X).angle(-45.0f).rescale(true).end().face(Direction.DOWN).uvs(0.0f, 16.0f, 16.0f, 0.0f).texture("#belt").end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#belt").end().end();
        this.fluidPipeCoreTemplate = this.models().getExistingFile(EPAPI.id("fluid_pipe_core_template"));
        this.fluidPipeSideConnectedTemplate = this.models().getExistingFile(EPAPI.id("fluid_pipe_side_connected_template"));
        this.fluidPipeSideExtractTemplate = this.models().getExistingFile(EPAPI.id("fluid_pipe_side_extract_template"));
        this.fluidTankTemplate = this.models().getExistingFile(EPAPI.id("fluid_tank_template"));
        this.cableCoreTemplate = ((BlockModelBuilder)this.models().withExistingParent("cable_core_template", "block/thin_block")).element().from(6.0f, 6.0f, 6.0f).to(10.0f, 10.0f, 10.0f).face(Direction.DOWN).uvs(0.0f, 7.0f, 4.0f, 11.0f).texture("#cable").end().face(Direction.UP).uvs(0.0f, 7.0f, 4.0f, 11.0f).texture("#cable").end().face(Direction.NORTH).uvs(0.0f, 7.0f, 4.0f, 11.0f).texture("#cable").end().face(Direction.SOUTH).uvs(0.0f, 7.0f, 4.0f, 11.0f).texture("#cable").end().face(Direction.WEST).uvs(0.0f, 7.0f, 4.0f, 11.0f).texture("#cable").end().face(Direction.EAST).uvs(0.0f, 7.0f, 4.0f, 11.0f).texture("#cable").end().end();
        this.cableSideTemplate = ((BlockModelBuilder)this.models().withExistingParent("cable_side_template", "block/thin_block")).element().from(6.0f, 6.0f, 0.0f).to(10.0f, 10.0f, 6.0f).face(Direction.DOWN).uvs(0.0f, 0.0f, 4.0f, 6.0f).texture("#cable").end().face(Direction.UP).uvs(0.0f, 0.0f, 4.0f, 6.0f).texture("#cable").end().face(Direction.NORTH).uvs(0.0f, 12.0f, 4.0f, 16.0f).texture("#cable").end().face(Direction.SOUTH).uvs(0.0f, 12.0f, 4.0f, 16.0f).texture("#cable").end().face(Direction.WEST).uvs(5.0f, 7.0f, 11.0f, 11.0f).texture("#cable").end().face(Direction.EAST).uvs(5.0f, 7.0f, 11.0f, 11.0f).texture("#cable").end().end();
        this.solarPanelTemplate = ((BlockModelBuilder)this.models().withExistingParent("solar_panel_template", "block/thin_block")).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 4.0f, 16.0f).face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).cullface(Direction.DOWN).texture("#side").end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#top").end().face(Direction.NORTH).uvs(0.0f, 12.0f, 16.0f, 16.0f).cullface(Direction.NORTH).texture("#side").end().face(Direction.SOUTH).uvs(0.0f, 12.0f, 16.0f, 16.0f).cullface(Direction.SOUTH).texture("#side").end().face(Direction.WEST).uvs(0.0f, 12.0f, 16.0f, 16.0f).cullface(Direction.WEST).texture("#side").end().face(Direction.EAST).uvs(0.0f, 12.0f, 16.0f, 16.0f).cullface(Direction.EAST).texture("#side").end().end();
        this.singleSideTemplate = this.models().getExistingFile(EPAPI.id("single_side"));
    }

    private void registerBlocks() {
        this.cubeAllBlockWithItem((Holder<? extends Block>)EPBlocks.SILICON_BLOCK);
        this.cubeAllBlockWithItem((Holder<? extends Block>)EPBlocks.TIN_BLOCK);
        this.cubeAllBlockWithItem((Holder<? extends Block>)EPBlocks.SAWDUST_BLOCK);
        this.cubeAllBlockWithItem((Holder<? extends Block>)EPBlocks.TIN_ORE);
        this.cubeAllBlockWithItem((Holder<? extends Block>)EPBlocks.DEEPSLATE_TIN_ORE);
        this.cubeAllBlockWithItem((Holder<? extends Block>)EPBlocks.RAW_TIN_BLOCK);
        this.itemConveyorBeltBlockWithItem((DeferredHolder<Block, ? extends ItemConveyorBeltBlock>)EPBlocks.BASIC_ITEM_CONVEYOR_BELT);
        this.itemConveyorBeltBlockWithItem((DeferredHolder<Block, ? extends ItemConveyorBeltBlock>)EPBlocks.FAST_ITEM_CONVEYOR_BELT);
        this.itemConveyorBeltBlockWithItem((DeferredHolder<Block, ? extends ItemConveyorBeltBlock>)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT);
        this.orientableSixDirsBlockWithBackItem((Holder<? extends Block>)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_LOADER, false);
        this.orientableSixDirsBlockWithBackItem((Holder<? extends Block>)EPBlocks.FAST_ITEM_CONVEYOR_BELT_LOADER, false);
        this.orientableSixDirsBlockWithBackItem((Holder<? extends Block>)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_LOADER, false);
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_SORTER, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_SORTER, "", "_top", "_top", "_input", "_output_2", "_output_3", "_output_1"));
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.FAST_ITEM_CONVEYOR_BELT_SORTER, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.FAST_ITEM_CONVEYOR_BELT_SORTER, "", "_top", "_top", "_input", "_output_2", "_output_3", "_output_1"));
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_SORTER, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_SORTER, "", "_top", "_top", "_input", "_output_2", "_output_3", "_output_1"));
        this.activatableOrientableBlockWithItem((Holder<? extends Block>)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_SWITCH, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_SWITCH, "", "_top", "_top", "_input", "_side", "_output_disabled", "_output_enabled"), this.cubeBlockModel((Holder<? extends Block>)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_SWITCH, "_powered", "_top", "_top", "_input", "_side", "_output_enabled", "_output_disabled"), ItemConveyorBeltSwitchBlock.POWERED);
        this.activatableOrientableBlockWithItem((Holder<? extends Block>)EPBlocks.FAST_ITEM_CONVEYOR_BELT_SWITCH, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.FAST_ITEM_CONVEYOR_BELT_SWITCH, "", "_top", "_top", "_input", "_side", "_output_disabled", "_output_enabled"), this.cubeBlockModel((Holder<? extends Block>)EPBlocks.FAST_ITEM_CONVEYOR_BELT_SWITCH, "_powered", "_top", "_top", "_input", "_side", "_output_enabled", "_output_disabled"), ItemConveyorBeltSwitchBlock.POWERED);
        this.activatableOrientableBlockWithItem((Holder<? extends Block>)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_SWITCH, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_SWITCH, "", "_top", "_top", "_input", "_side", "_output_disabled", "_output_enabled"), this.cubeBlockModel((Holder<? extends Block>)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_SWITCH, "_powered", "_top", "_top", "_input", "_side", "_output_enabled", "_output_disabled"), ItemConveyorBeltSwitchBlock.POWERED);
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_SPLITTER, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_SPLITTER, "", "_top", "_top", "_input", "_output", "_output", "_output"));
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.FAST_ITEM_CONVEYOR_BELT_SPLITTER, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.FAST_ITEM_CONVEYOR_BELT_SPLITTER, "", "_top", "_top", "_input", "_output", "_output", "_output"));
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_SPLITTER, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_SPLITTER, "", "_top", "_top", "_input", "_output", "_output", "_output"));
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_MERGER, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.BASIC_ITEM_CONVEYOR_BELT_MERGER, "", "_top", "_top", "_output", "_input", "_input", "_input"));
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.FAST_ITEM_CONVEYOR_BELT_MERGER, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.FAST_ITEM_CONVEYOR_BELT_MERGER, "", "_top", "_top", "_output", "_input", "_input", "_input"));
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_MERGER, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.EXPRESS_ITEM_CONVEYOR_BELT_MERGER, "", "_top", "_top", "_output", "_input", "_input", "_input"));
        this.fluidPipeBlockWithItem((Holder<? extends Block>)EPBlocks.IRON_FLUID_PIPE);
        this.fluidPipeBlockWithItem((Holder<? extends Block>)EPBlocks.GOLDEN_FLUID_PIPE);
        this.fluidTankBlockWithItem((Holder<? extends Block>)EPBlocks.FLUID_TANK_SMALL);
        this.fluidTankBlockWithItem((Holder<? extends Block>)EPBlocks.FLUID_TANK_MEDIUM);
        this.fluidTankBlockWithItem((Holder<? extends Block>)EPBlocks.FLUID_TANK_LARGE);
        this.fluidTankBlockWithItem((Holder<? extends Block>)EPBlocks.CREATIVE_FLUID_TANK);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.ITEM_SILO_TINY, false);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.ITEM_SILO_SMALL, false);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.ITEM_SILO_MEDIUM, false);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.ITEM_SILO_LARGE, false);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.ITEM_SILO_GIANT, false);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.CREATIVE_ITEM_SILO, false);
        this.cableBlockWithItem((Holder<? extends Block>)EPBlocks.TIN_CABLE);
        this.cableBlockWithItem((Holder<? extends Block>)EPBlocks.COPPER_CABLE);
        this.cableBlockWithItem((Holder<? extends Block>)EPBlocks.GOLD_CABLE);
        this.cableBlockWithItem((Holder<? extends Block>)EPBlocks.ENERGIZED_COPPER_CABLE);
        this.cableBlockWithItem((Holder<? extends Block>)EPBlocks.ENERGIZED_GOLD_CABLE);
        this.cableBlockWithItem((Holder<? extends Block>)EPBlocks.ENERGIZED_CRYSTAL_MATRIX_CABLE);
        this.transformerBlockWithItem((DeferredHolder<Block, ? extends TransformerBlock>)EPBlocks.LV_TRANSFORMER_1_TO_N);
        this.transformerBlockWithItem((DeferredHolder<Block, ? extends TransformerBlock>)EPBlocks.LV_TRANSFORMER_3_TO_3);
        this.transformerBlockWithItem((DeferredHolder<Block, ? extends TransformerBlock>)EPBlocks.LV_TRANSFORMER_N_TO_1);
        this.transformerBlockWithItem((DeferredHolder<Block, ? extends TransformerBlock>)EPBlocks.MV_TRANSFORMER_1_TO_N);
        this.transformerBlockWithItem((DeferredHolder<Block, ? extends TransformerBlock>)EPBlocks.MV_TRANSFORMER_3_TO_3);
        this.transformerBlockWithItem((DeferredHolder<Block, ? extends TransformerBlock>)EPBlocks.MV_TRANSFORMER_N_TO_1);
        this.transformerBlockWithItem((DeferredHolder<Block, ? extends TransformerBlock>)EPBlocks.HV_TRANSFORMER_1_TO_N);
        this.transformerBlockWithItem((DeferredHolder<Block, ? extends TransformerBlock>)EPBlocks.HV_TRANSFORMER_3_TO_3);
        this.transformerBlockWithItem((DeferredHolder<Block, ? extends TransformerBlock>)EPBlocks.HV_TRANSFORMER_N_TO_1);
        this.transformerBlockWithItem((DeferredHolder<Block, ? extends TransformerBlock>)EPBlocks.EHV_TRANSFORMER_1_TO_N);
        this.transformerBlockWithItem((DeferredHolder<Block, ? extends TransformerBlock>)EPBlocks.EHV_TRANSFORMER_3_TO_3);
        this.transformerBlockWithItem((DeferredHolder<Block, ? extends TransformerBlock>)EPBlocks.EHV_TRANSFORMER_N_TO_1);
        this.configurableTransformerBlockWithItem(EPBlocks.CONFIGURABLE_LV_TRANSFORMER);
        this.configurableTransformerBlockWithItem(EPBlocks.CONFIGURABLE_MV_TRANSFORMER);
        this.configurableTransformerBlockWithItem(EPBlocks.CONFIGURABLE_HV_TRANSFORMER);
        this.configurableTransformerBlockWithItem(EPBlocks.CONFIGURABLE_EHV_TRANSFORMER);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.BATTERY_BOX, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.ADVANCED_BATTERY_BOX, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.CREATIVE_BATTERY_BOX, true);
        this.horizontalTwoSideBlockWithItem((Holder<? extends Block>)EPBlocks.PRESS_MOLD_MAKER, true);
        this.activatableOrientableBlockWithItem((Holder<? extends Block>)EPBlocks.ALLOY_FURNACE, this.orientableBlockModel((Holder<? extends Block>)EPBlocks.ALLOY_FURNACE, false), this.orientableOnBlockModel((Holder<? extends Block>)EPBlocks.ALLOY_FURNACE, false), AlloyFurnaceBlock.LIT);
        this.horizontalTwoSideBlockWithItem((Holder<? extends Block>)EPBlocks.AUTO_CRAFTER, true);
        this.horizontalTwoSideBlockWithItem((Holder<? extends Block>)EPBlocks.ADVANCED_AUTO_CRAFTER, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.CRUSHER, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.ADVANCED_CRUSHER, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.PULVERIZER, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.ADVANCED_PULVERIZER, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.SAWMILL, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.COMPRESSOR, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.METAL_PRESS, false);
        this.horizontalTwoSideBlockWithItem((Holder<? extends Block>)EPBlocks.AUTO_PRESS_MOLD_MAKER, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.AUTO_STONECUTTER, false);
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.PLANT_GROWTH_CHAMBER, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.PLANT_GROWTH_CHAMBER, "", "_top", "_top", "_front", "_front", "_side", "_side"));
        this.orientableSixDirsBlockWithItem((Holder<? extends Block>)EPBlocks.BLOCK_PLACER, true);
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.ASSEMBLING_MACHINE, this.orientableBlockModel((Holder<? extends Block>)EPBlocks.ASSEMBLING_MACHINE, false));
        this.activatableOrientableMachineBlockWithItem((Holder<? extends Block>)EPBlocks.INDUCTION_SMELTER, false);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.FLUID_FILLER, true);
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.STONE_LIQUEFIER, this.orientableBlockModel((Holder<? extends Block>)EPBlocks.STONE_LIQUEFIER, false));
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.STONE_SOLIDIFIER, this.orientableBlockModel((Holder<? extends Block>)EPBlocks.STONE_SOLIDIFIER, false));
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.FLUID_TRANSPOSER, this.orientableBlockModel((Holder<? extends Block>)EPBlocks.FLUID_TRANSPOSER, false));
        this.horizontalTwoSideBlockWithItem((Holder<? extends Block>)EPBlocks.FILTRATION_PLANT, false);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.FLUID_DRAINER, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.FLUID_PUMP, false);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.ADVANCED_FLUID_PUMP, false);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.DRAIN, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.CHARGER, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.ADVANCED_CHARGER, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.UNCHARGER, true);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.ADVANCED_UNCHARGER, true);
        this.orientableSixDirsBlockWithItem((Holder<? extends Block>)EPBlocks.MINECART_CHARGER, true);
        this.orientableSixDirsBlockWithItem((Holder<? extends Block>)EPBlocks.ADVANCED_MINECART_CHARGER, true);
        this.orientableSixDirsBlockWithItem((Holder<? extends Block>)EPBlocks.MINECART_UNCHARGER, true);
        this.orientableSixDirsBlockWithItem((Holder<? extends Block>)EPBlocks.ADVANCED_MINECART_UNCHARGER, true);
        this.solarPanelBlockWithItem((Holder<? extends Block>)EPBlocks.SOLAR_PANEL_1);
        this.solarPanelBlockWithItem((Holder<? extends Block>)EPBlocks.SOLAR_PANEL_2);
        this.solarPanelBlockWithItem((Holder<? extends Block>)EPBlocks.SOLAR_PANEL_3);
        this.solarPanelBlockWithItem((Holder<? extends Block>)EPBlocks.SOLAR_PANEL_4);
        this.solarPanelBlockWithItem((Holder<? extends Block>)EPBlocks.SOLAR_PANEL_5);
        this.solarPanelBlockWithItem((Holder<? extends Block>)EPBlocks.SOLAR_PANEL_6);
        this.activatableOrientableMachineBlockWithItem((Holder<? extends Block>)EPBlocks.COAL_ENGINE, false);
        this.poweredLampBlockWithItem((Holder<? extends Block>)EPBlocks.POWERED_LAMP);
        this.activatableOrientableMachineBlockWithItem((Holder<? extends Block>)EPBlocks.POWERED_FURNACE, false);
        this.activatableOrientableMachineBlockWithItem((Holder<? extends Block>)EPBlocks.ADVANCED_POWERED_FURNACE, false);
        this.activatableBlockWithItem((Holder<? extends Block>)EPBlocks.LIGHTNING_GENERATOR, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.LIGHTNING_GENERATOR, "", "_top", "_bottom", "_side", "_side", "_side", "_side"), this.cubeBlockModel((Holder<? extends Block>)EPBlocks.LIGHTNING_GENERATOR, "_on", "_top_on", "_bottom", "_side_on", "_side_on", "_side_on", "_side_on"), LightningGeneratorBlock.HIT_BY_LIGHTNING_BOLT);
        this.activatableOrientableBlockWithItem((Holder<? extends Block>)EPBlocks.ENERGIZER, this.orientableBlockModel((Holder<? extends Block>)EPBlocks.ENERGIZER, true), this.orientableBlockModel((Holder<? extends Block>)EPBlocks.ENERGIZER, "_on", "_top_on", "_bottom", "_front_on", "_side_on"), EnergizerBlock.LIT);
        this.activatableBlockWithItem((Holder<? extends Block>)EPBlocks.CHARGING_STATION, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.CHARGING_STATION, "", "_top", "_bottom", "_side", "_side", "_side", "_side"), this.cubeBlockModel((Holder<? extends Block>)EPBlocks.CHARGING_STATION, "_on", "_top_on", "_bottom", "_side_on", "_side_on", "_side_on", "_side_on"), ChargingStationBlock.CHARGING);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.HEAT_GENERATOR, false);
        this.orientableBlockWithItem((Holder<? extends Block>)EPBlocks.THERMAL_GENERATOR, this.orientableBlockModel((Holder<? extends Block>)EPBlocks.THERMAL_GENERATOR, false));
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.CRYSTAL_GROWTH_CHAMBER, false);
        this.horizontalTwoSideBlockWithItem((Holder<? extends Block>)EPBlocks.WEATHER_CONTROLLER, false);
        this.horizontalTwoSideBlockWithItem((Holder<? extends Block>)EPBlocks.TIME_CONTROLLER, false);
        this.activatableBlockWithItem((Holder<? extends Block>)EPBlocks.TELEPORTER, this.cubeBlockModel((Holder<? extends Block>)EPBlocks.TELEPORTER, "", "_top", "_bottom", "_side", "_side", "_side", "_side"), this.cubeBlockModel((Holder<? extends Block>)EPBlocks.TELEPORTER, "_ready", "_top_ready", "_bottom", "_side", "_side", "_side", "_side"), TeleporterBlock.POWERED);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.BASIC_MACHINE_FRAME, false);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.HARDENED_MACHINE_FRAME, false);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.ADVANCED_MACHINE_FRAME, false);
        this.horizontalBlockWithItem((Holder<? extends Block>)EPBlocks.REINFORCED_ADVANCED_MACHINE_FRAME, false);
    }

    private ModelFile cubeBlockModel(Holder<? extends Block> block, String fileSuffix, String upSuffix, String bottomSuffix, String northSuffix, String southSuffix, String westSuffix, String eastSuffix) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.getPath() + fileSuffix, "block/cube")).texture("particle", "#up")).texture("up", this.getBlockTexture(block, upSuffix))).texture("down", this.getBlockTexture(block, bottomSuffix))).texture("north", this.getBlockTexture(block, northSuffix))).texture("south", this.getBlockTexture(block, southSuffix))).texture("west", this.getBlockTexture(block, westSuffix))).texture("east", this.getBlockTexture(block, eastSuffix));
    }

    private ModelFile orientableBlockModel(Holder<? extends Block> block, boolean uniqueBottomTexture) {
        return this.orientableBlockModel(block, "", "_top", uniqueBottomTexture ? "_bottom" : "_top", "_front", "_side");
    }

    private ModelFile orientableOnBlockModel(Holder<? extends Block> block, boolean uniqueBottomTexture) {
        return this.orientableBlockModel(block, "_on", "_top", uniqueBottomTexture ? "_bottom" : "_top", "_front_on", "_side");
    }

    private ModelFile orientableBlockModel(Holder<? extends Block> block, String fileSuffix, String topSuffix, String bottomSuffix, String frontSuffix, String sideSuffix) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.getPath() + fileSuffix, "block/orientable")).texture("particle", "#top")).texture("top", this.getBlockTexture(block, topSuffix))).texture("bottom", this.getBlockTexture(block, bottomSuffix))).texture("front", this.getBlockTexture(block, frontSuffix))).texture("side", this.getBlockTexture(block, sideSuffix));
    }

    private ModelFile orientableWithBackBlockModel(Holder<? extends Block> block, boolean uniqueBottomTexture) {
        return this.orientableWithBackBlockModel(block, "", "_top", uniqueBottomTexture ? "_bottom" : "_top", "_front", "_back", "_side");
    }

    private ModelFile orientableWithBackBlockModel(Holder<? extends Block> block, String fileSuffix, String topSuffix, String bottomSuffix, String frontSuffix, String backSuffix, String sideSuffix) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.getPath() + fileSuffix, "block/cube")).texture("particle", "#up")).texture("up", this.getBlockTexture(block, topSuffix))).texture("down", this.getBlockTexture(block, bottomSuffix))).texture("north", this.getBlockTexture(block, frontSuffix))).texture("south", this.getBlockTexture(block, backSuffix))).texture("west", this.getBlockTexture(block, sideSuffix))).texture("east", this.getBlockTexture(block, sideSuffix));
    }

    private ModelFile orientableVerticalWithBackBlockModel(Holder<? extends Block> block, boolean uniqueBottomTexture) {
        return this.orientableVerticalWithBackBlockModel(block, "_vertical", "_top", uniqueBottomTexture ? "_bottom" : "_top", "_front", "_back", "_side");
    }

    private ModelFile orientableVerticalWithBackBlockModel(Holder<? extends Block> block, String fileSuffix, String topSuffix, String bottomSuffix, String frontSuffix, String backSuffix, String sideSuffix) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.getPath() + fileSuffix, "block/cube")).element().face(Direction.UP).cullface(Direction.UP).texture("#front").end().face(Direction.DOWN).uvs(0.0f, 16.0f, 16.0f, 0.0f).cullface(Direction.DOWN).texture("#back").end().face(Direction.NORTH).cullface(Direction.NORTH).texture("#top").end().face(Direction.SOUTH).cullface(Direction.SOUTH).texture("#bottom").end().face(Direction.WEST).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).cullface(Direction.WEST).texture("#side").end().face(Direction.EAST).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).cullface(Direction.EAST).texture("#side").end().end()).texture("particle", "#top")).texture("top", this.getBlockTexture(block, topSuffix))).texture("bottom", this.getBlockTexture(block, bottomSuffix))).texture("front", this.getBlockTexture(block, frontSuffix))).texture("back", this.getBlockTexture(block, backSuffix))).texture("side", this.getBlockTexture(block, sideSuffix));
    }

    private ModelFile orientableVerticalBlockModel(Holder<? extends Block> block, boolean uniqueBottomTexture) {
        return this.orientableVerticalBlockModel(block, "_vertical", "_top", uniqueBottomTexture ? "_bottom" : "_top", "_front", "_side");
    }

    private ModelFile orientableVerticalBlockModel(Holder<? extends Block> block, String fileSuffix, String topSuffix, String bottomSuffix, String frontSuffix, String sideSuffix) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.getPath() + fileSuffix, "block/orientable")).element().face(Direction.UP).cullface(Direction.UP).texture("#front").end().face(Direction.DOWN).uvs(0.0f, 16.0f, 16.0f, 0.0f).cullface(Direction.DOWN).texture("#side").end().face(Direction.NORTH).cullface(Direction.NORTH).texture("#top").end().face(Direction.SOUTH).cullface(Direction.SOUTH).texture("#bottom").end().face(Direction.WEST).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).cullface(Direction.WEST).texture("#side").end().face(Direction.EAST).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).cullface(Direction.EAST).texture("#side").end().end()).texture("particle", "#top")).texture("top", this.getBlockTexture(block, topSuffix))).texture("bottom", this.getBlockTexture(block, bottomSuffix))).texture("front", this.getBlockTexture(block, frontSuffix))).texture("side", this.getBlockTexture(block, sideSuffix));
    }

    private void cubeAllBlockWithItem(Holder<? extends Block> block) {
        this.simpleBlockWithItem((Block)block.value(), this.cubeAll((Block)block.value()));
    }

    private void horizontalBlockWithItem(Holder<? extends Block> block, boolean uniqueBottomTexture) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.getPath(), "block/cube")).texture("particle", "#up")).texture("up", this.getBlockTexture(block, "_top"))).texture("down", this.getBlockTexture(block, uniqueBottomTexture ? "_bottom" : "_top"))).texture("north", this.getBlockTexture(block, "_side"))).texture("south", this.getBlockTexture(block, "_side"))).texture("east", this.getBlockTexture(block, "_side"))).texture("west", this.getBlockTexture(block, "_side"));
        this.simpleBlockWithItem((Block)block.value(), (ModelFile)model);
    }

    private void horizontalTwoSideBlockWithItem(Holder<? extends Block> block, boolean uniqueBottomTexture) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.getPath(), "block/cube")).texture("particle", "#up")).texture("up", this.getBlockTexture(block, "_top"))).texture("down", this.getBlockTexture(block, uniqueBottomTexture ? "_bottom" : "_top"))).texture("north", this.getBlockTexture(block, "_front"))).texture("south", this.getBlockTexture(block, "_side"))).texture("east", this.getBlockTexture(block, "_side"))).texture("west", this.getBlockTexture(block, "_front"));
        this.simpleBlockWithItem((Block)block.value(), (ModelFile)model);
    }

    private void orientableBlockWithItem(Holder<? extends Block> block, ModelFile model) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.value()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).modelForState().modelFile(model).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).modelForState().rotationY(180).modelFile(model).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).modelForState().rotationY(90).modelFile(model).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).modelForState().rotationY(270).modelFile(model).addModel()).partialState();
        this.simpleBlockItem((Block)block.value(), model);
    }

    private void orientableSixDirsBlockWithBackItem(Holder<? extends Block> block, boolean uniqueBottomTexture) {
        this.orientableSixDirsBlockWithItem(block, this.orientableWithBackBlockModel(block, uniqueBottomTexture), this.orientableVerticalWithBackBlockModel(block, uniqueBottomTexture));
    }

    private void orientableSixDirsBlockWithItem(Holder<? extends Block> block, boolean uniqueBottomTexture) {
        this.orientableSixDirsBlockWithItem(block, this.orientableBlockModel(block, uniqueBottomTexture), this.orientableVerticalBlockModel(block, uniqueBottomTexture));
    }

    private void orientableSixDirsBlockWithItem(Holder<? extends Block> block, ModelFile modelNormal, ModelFile modelVertical) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.value()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.UP).modelForState().modelFile(modelVertical).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN).modelForState().rotationX(180).modelFile(modelVertical).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH).modelForState().modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH).modelForState().rotationY(180).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST).modelForState().rotationY(90).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST).modelForState().rotationY(270).modelFile(modelNormal).addModel()).partialState();
        this.simpleBlockItem((Block)block.value(), modelNormal);
    }

    private void activatableBlockWithItem(Holder<? extends Block> block, ModelFile modelNormal, ModelFile modelActive, BooleanProperty isActiveProperty) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.value()).partialState().with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(modelNormal).addModel()).partialState().with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(modelActive).addModel()).partialState();
        this.simpleBlockItem((Block)block.value(), modelNormal);
    }

    private void activatableOrientableBlockWithItem(Holder<? extends Block> block, ModelFile modelNormal, ModelFile modelActive, BooleanProperty isActiveProperty) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.value()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(modelActive).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().rotationY(180).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().rotationY(180).modelFile(modelActive).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().rotationY(90).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().rotationY(90).modelFile(modelActive).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().rotationY(270).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().rotationY(270).modelFile(modelActive).addModel()).partialState();
        this.simpleBlockItem((Block)block.value(), modelNormal);
    }

    private void itemConveyorBeltBlockWithItem(DeferredHolder<Block, ? extends ItemConveyorBeltBlock> block) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        ModelBuilder modelFlat = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.getPath() + "_flat")).parent(this.itemConveyorBeltFlatTemplate)).texture("particle", "#belt")).texture("belt", this.getBlockTexture((Holder<? extends Block>)block));
        ModelBuilder modelAscending = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.getPath() + "_ascending")).parent(this.itemConveyorBeltAscendingTemplate)).texture("particle", "#belt")).texture("belt", this.getBlockTexture((Holder<? extends Block>)block));
        ModelBuilder modelDescending = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.getPath() + "_descending")).parent(this.itemConveyorBeltDescendingTemplate)).texture("particle", "#belt")).texture("belt", this.getBlockTexture((Holder<? extends Block>)block));
        VariantBlockStateBuilder blockStateBuilder = this.getVariantBuilder((Block)block.value());
        for (EPBlockStateProperties.ConveyorBeltDirection beltDir : EPBlockStateProperties.ConveyorBeltDirection.values()) {
            ConfiguredModel.Builder configuredModelBuilder = blockStateBuilder.partialState().with(ItemConveyorBeltBlock.FACING, (Comparable)((Object)beltDir)).modelForState();
            if (beltDir.isAscending()) {
                switch (beltDir.getDirection()) {
                    case NORTH: {
                        configuredModelBuilder.rotationY(180);
                        break;
                    }
                    case WEST: {
                        configuredModelBuilder.rotationY(90);
                        break;
                    }
                    case EAST: {
                        configuredModelBuilder.rotationY(270);
                    }
                }
                configuredModelBuilder.modelFile((ModelFile)modelAscending).addModel();
                continue;
            }
            if (beltDir.isDescending()) {
                switch (beltDir.getDirection()) {
                    case SOUTH: {
                        configuredModelBuilder.rotationY(180);
                        break;
                    }
                    case WEST: {
                        configuredModelBuilder.rotationY(270);
                        break;
                    }
                    case EAST: {
                        configuredModelBuilder.rotationY(90);
                    }
                }
                configuredModelBuilder.modelFile((ModelFile)modelDescending).addModel();
                continue;
            }
            switch (beltDir.getDirection()) {
                case NORTH: {
                    configuredModelBuilder.rotationY(180);
                    break;
                }
                case WEST: {
                    configuredModelBuilder.rotationY(90);
                    break;
                }
                case EAST: {
                    configuredModelBuilder.rotationY(270);
                }
            }
            configuredModelBuilder.modelFile((ModelFile)modelFlat).addModel();
        }
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(blockId.getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.getBlockTexture((Holder<? extends Block>)block));
    }

    private void fluidPipeBlockWithItem(Holder<? extends Block> block) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        ModelBuilder fluidPipeCore = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.getPath() + "_core")).parent(this.fluidPipeCoreTemplate)).texture("particle", this.getBlockTexture(block, "_core"))).texture("fluid_pipe_core", this.getBlockTexture(block, "_core"));
        ModelBuilder fluidPipeSideConnected = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.getPath() + "_side_connected")).parent(this.fluidPipeSideConnectedTemplate)).texture("particle", this.getBlockTexture(block, "_side_connected"))).texture("fluid_pipe_side", this.getBlockTexture(block, "_side_connected"));
        ModelBuilder fluidPipeSideExtract = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.getPath() + "_side_extract")).parent(this.fluidPipeSideExtractTemplate)).texture("particle", this.getBlockTexture(block, "_side_outer_extract"))).texture("fluid_pipe_side_inner", this.getBlockTexture(block, "_side_inner_extract"))).texture("fluid_pipe_side_outer", this.getBlockTexture(block, "_side_outer_extract"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block.value()).part().modelFile((ModelFile)fluidPipeCore).addModel()).end().part().modelFile((ModelFile)fluidPipeSideConnected).rotationX(270).addModel()).condition(FluidPipeBlock.UP, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.CONNECTED}).end().part().modelFile((ModelFile)fluidPipeSideExtract).rotationX(270).addModel()).condition(FluidPipeBlock.UP, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.EXTRACT}).end().part().modelFile((ModelFile)fluidPipeSideConnected).rotationX(90).addModel()).condition(FluidPipeBlock.DOWN, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.CONNECTED}).end().part().modelFile((ModelFile)fluidPipeSideExtract).rotationX(90).addModel()).condition(FluidPipeBlock.DOWN, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.EXTRACT}).end().part().modelFile((ModelFile)fluidPipeSideConnected).addModel()).condition(FluidPipeBlock.NORTH, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.CONNECTED}).end().part().modelFile((ModelFile)fluidPipeSideExtract).addModel()).condition(FluidPipeBlock.NORTH, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.EXTRACT}).end().part().modelFile((ModelFile)fluidPipeSideConnected).rotationX(180).addModel()).condition(FluidPipeBlock.SOUTH, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.CONNECTED}).end().part().modelFile((ModelFile)fluidPipeSideExtract).rotationX(180).addModel()).condition(FluidPipeBlock.SOUTH, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.EXTRACT}).end().part().modelFile((ModelFile)fluidPipeSideConnected).rotationY(90).addModel()).condition(FluidPipeBlock.EAST, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.CONNECTED}).end().part().modelFile((ModelFile)fluidPipeSideExtract).rotationY(90).addModel()).condition(FluidPipeBlock.EAST, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.EXTRACT}).end().part().modelFile((ModelFile)fluidPipeSideConnected).rotationY(270).addModel()).condition(FluidPipeBlock.WEST, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.CONNECTED}).end().part().modelFile((ModelFile)fluidPipeSideExtract).rotationY(270).addModel()).condition(FluidPipeBlock.WEST, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.EXTRACT}).end();
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(blockId.getPath())).parent((ModelFile)fluidPipeCore)).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 45.0f, 0.0f).end().transform(ItemDisplayContext.GROUND).scale(0.65f, 0.65f, 0.65f).end().transform(ItemDisplayContext.FIXED).scale(0.65f, 0.65f, 0.65f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).scale(0.65f, 0.65f, 0.65f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).scale(0.65f, 0.65f, 0.65f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).scale(0.65f, 0.65f, 0.65f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).scale(0.65f, 0.65f, 0.65f).end().end();
    }

    private void fluidTankBlockWithItem(Holder<? extends Block> block) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        ModelBuilder fluidTank = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.getPath())).parent(this.fluidTankTemplate)).texture("particle", "#up")).texture("front", this.getBlockTexture(block, "_front"))).texture("side", this.getBlockTexture(block, "_side"))).texture("up", this.getBlockTexture(block, "_top"))).texture("interior", this.getBlockTexture(block, "_interior"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.value()).partialState().with((Property)FluidTankBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)fluidTank).addModel()).partialState().with((Property)FluidTankBlock.FACING, (Comparable)Direction.SOUTH).modelForState().rotationY(180).modelFile((ModelFile)fluidTank).addModel()).partialState().with((Property)FluidTankBlock.FACING, (Comparable)Direction.EAST).modelForState().rotationY(90).modelFile((ModelFile)fluidTank).addModel()).partialState().with((Property)FluidTankBlock.FACING, (Comparable)Direction.WEST).modelForState().rotationY(270).modelFile((ModelFile)fluidTank).addModel()).partialState();
        this.simpleBlockItem((Block)block.value(), (ModelFile)fluidTank);
    }

    private void cableBlockWithItem(Holder<? extends Block> block) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        ModelBuilder cableCore = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.getPath() + "_core")).parent(this.cableCoreTemplate)).texture("particle", this.getBlockTexture(block))).texture("cable", this.getBlockTexture(block));
        ModelBuilder cableSide = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.getPath() + "_side")).parent(this.cableSideTemplate)).texture("particle", this.getBlockTexture(block))).texture("cable", this.getBlockTexture(block));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block.value()).part().modelFile((ModelFile)cableCore).addModel()).end().part().modelFile((ModelFile)cableSide).rotationX(270).addModel()).condition((Property)CableBlock.UP, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)cableSide).rotationX(90).addModel()).condition((Property)CableBlock.DOWN, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)cableSide).addModel()).condition((Property)CableBlock.NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)cableSide).rotationX(180).addModel()).condition((Property)CableBlock.SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)cableSide).rotationY(90).addModel()).condition((Property)CableBlock.EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)cableSide).rotationY(270).addModel()).condition((Property)CableBlock.WEST, (Comparable[])new Boolean[]{true}).end();
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(blockId.getPath())).parent((ModelFile)cableCore)).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 45.0f, 0.0f).scale(1.5f, 1.5f, 1.5f).end().transform(ItemDisplayContext.GROUND).scale(1.01f, 1.01f, 1.01f).end().transform(ItemDisplayContext.FIXED).scale(1.01f, 1.01f, 1.01f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).scale(1.01f, 1.01f, 1.01f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).scale(1.01f, 1.01f, 1.01f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).scale(1.01f, 1.01f, 1.01f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).scale(1.01f, 1.01f, 1.01f).end().end();
    }

    private void transformerBlockWithItem(DeferredHolder<Block, ? extends TransformerBlock> block) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        String textureName = switch (((TransformerBlock)((Object)block.get())).getTier()) {
            default -> throw new MatchException(null, null);
            case TransformerTier.LV -> "lv_transformer";
            case TransformerTier.MV -> "mv_transformer";
            case TransformerTier.HV -> "hv_transformer";
            case TransformerTier.EHV -> "ehv_transformer";
        };
        TransformerType transformerType = ((TransformerBlock)((Object)block.get())).getTransformerType();
        switch (transformerType) {
            case TYPE_1_TO_N: 
            case TYPE_N_TO_1: {
                String singleSuffix = transformerType == TransformerType.TYPE_1_TO_N ? "_input" : "_output";
                String multipleSuffix = transformerType == TransformerType.TYPE_1_TO_N ? "_output" : "_input";
                ModelBuilder transformer = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.getPath(), "block/orientable")).texture("particle", "#top")).texture("top", "block/" + textureName + multipleSuffix)).texture("bottom", "block/" + textureName + multipleSuffix)).texture("front", "block/" + textureName + singleSuffix)).texture("side", "block/" + textureName + multipleSuffix);
                ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.value()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.UP).modelForState().rotationX(270).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.DOWN).modelForState().rotationX(90).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.SOUTH).modelForState().rotationY(180).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.EAST).modelForState().rotationY(90).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.WEST).modelForState().rotationY(270).modelFile((ModelFile)transformer).addModel()).partialState();
                this.simpleBlockItem((Block)block.value(), (ModelFile)transformer);
                break;
            }
            case TYPE_3_TO_3: {
                ModelBuilder transformer = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.getPath(), "block/cube")).texture("particle", "#up")).texture("up", "block/" + textureName + "_input")).texture("down", "block/" + textureName + "_output")).texture("north", "block/" + textureName + "_input")).texture("south", "block/" + textureName + "_output")).texture("east", "block/" + textureName + "_output")).texture("west", "block/" + textureName + "_input");
                ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.value()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.UP).modelForState().rotationX(270).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.DOWN).modelForState().rotationX(90).rotationY(90).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.SOUTH).modelForState().rotationX(90).rotationY(180).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.EAST).modelForState().rotationY(90).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.WEST).modelForState().rotationX(90).rotationY(270).modelFile((ModelFile)transformer).addModel()).partialState();
                this.simpleBlockItem((Block)block.value(), (ModelFile)transformer);
            }
        }
    }

    private void configurableTransformerBlockWithItem(DeferredBlock<ConfigurableTransformerBlock> block) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        String textureName = switch (((ConfigurableTransformerBlock)block.value()).getTier()) {
            default -> throw new MatchException(null, null);
            case TransformerTier.LV -> "lv_transformer";
            case TransformerTier.MV -> "mv_transformer";
            case TransformerTier.HV -> "hv_transformer";
            case TransformerTier.EHV -> "ehv_transformer";
        };
        ModelBuilder allCube = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.getPath() + "_cube", "block/cube")).texture("particle", "#up")).texture("up", "block/" + textureName + "_not_connected")).texture("down", "block/" + textureName + "_not_connected")).texture("north", "block/" + textureName + "_output")).texture("south", "block/" + textureName + "_not_connected")).texture("east", "block/" + textureName + "_input")).texture("west", "block/" + textureName + "_not_connected");
        ModelBuilder notConnectedSide = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.getPath() + "_not_connected")).parent(this.singleSideTemplate)).texture("particle", "#side")).texture("side", "block/" + textureName + "_not_connected");
        ModelBuilder receiveSide = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.getPath() + "_input")).parent(this.singleSideTemplate)).texture("particle", "#side")).texture("side", "block/" + textureName + "_input");
        ModelBuilder extractSide = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.getPath() + "_output")).parent(this.singleSideTemplate)).texture("particle", "#side")).texture("side", "block/" + textureName + "_output");
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block.value()).part().modelFile((ModelFile)notConnectedSide).rotationX(270).addModel()).condition(ConfigurableTransformerBlock.UP, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.NOT_CONNECTED}).end().part().modelFile((ModelFile)receiveSide).rotationX(270).addModel()).condition(ConfigurableTransformerBlock.UP, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.RECEIVE}).end().part().modelFile((ModelFile)extractSide).rotationX(270).addModel()).condition(ConfigurableTransformerBlock.UP, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.EXTRACT}).end().part().modelFile((ModelFile)notConnectedSide).rotationX(90).addModel()).condition(ConfigurableTransformerBlock.DOWN, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.NOT_CONNECTED}).end().part().modelFile((ModelFile)receiveSide).rotationX(90).addModel()).condition(ConfigurableTransformerBlock.DOWN, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.RECEIVE}).end().part().modelFile((ModelFile)extractSide).rotationX(90).addModel()).condition(ConfigurableTransformerBlock.DOWN, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.EXTRACT}).end().part().modelFile((ModelFile)notConnectedSide).addModel()).condition(ConfigurableTransformerBlock.NORTH, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.NOT_CONNECTED}).end().part().modelFile((ModelFile)receiveSide).addModel()).condition(ConfigurableTransformerBlock.NORTH, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.RECEIVE}).end().part().modelFile((ModelFile)extractSide).addModel()).condition(ConfigurableTransformerBlock.NORTH, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.EXTRACT}).end().part().modelFile((ModelFile)notConnectedSide).rotationX(180).addModel()).condition(ConfigurableTransformerBlock.SOUTH, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.NOT_CONNECTED}).end().part().modelFile((ModelFile)receiveSide).rotationX(180).addModel()).condition(ConfigurableTransformerBlock.SOUTH, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.RECEIVE}).end().part().modelFile((ModelFile)extractSide).rotationX(180).addModel()).condition(ConfigurableTransformerBlock.SOUTH, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.EXTRACT}).end().part().modelFile((ModelFile)notConnectedSide).rotationY(90).addModel()).condition(ConfigurableTransformerBlock.EAST, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.NOT_CONNECTED}).end().part().modelFile((ModelFile)receiveSide).rotationY(90).addModel()).condition(ConfigurableTransformerBlock.EAST, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.RECEIVE}).end().part().modelFile((ModelFile)extractSide).rotationY(90).addModel()).condition(ConfigurableTransformerBlock.EAST, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.EXTRACT}).end().part().modelFile((ModelFile)notConnectedSide).rotationY(270).addModel()).condition(ConfigurableTransformerBlock.WEST, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.NOT_CONNECTED}).end().part().modelFile((ModelFile)receiveSide).rotationY(270).addModel()).condition(ConfigurableTransformerBlock.WEST, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.RECEIVE}).end().part().modelFile((ModelFile)extractSide).rotationY(270).addModel()).condition(ConfigurableTransformerBlock.WEST, (Comparable[])new EPBlockStateProperties.TransformerConnection[]{EPBlockStateProperties.TransformerConnection.EXTRACT}).end();
        this.simpleBlockItem((Block)block.value(), (ModelFile)allCube);
    }

    private void solarPanelBlockWithItem(Holder<? extends Block> block) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        ModelBuilder solarPanel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.getPath())).parent(this.solarPanelTemplate)).texture("particle", "#top")).texture("top", this.getBlockTexture(block, "_top"))).texture("side", this.getBlockTexture(block, "_side"));
        this.getVariantBuilder((Block)block.value()).partialState().modelForState().modelFile((ModelFile)solarPanel).addModel();
        this.simpleBlockItem((Block)block.value(), (ModelFile)solarPanel);
    }

    private void activatableOrientableMachineBlockWithItem(Holder<? extends Block> block, boolean uniqueBottomTexture) {
        this.activatableOrientableBlockWithItem(block, this.orientableBlockModel(block, uniqueBottomTexture), this.orientableOnBlockModel(block, uniqueBottomTexture), BlockStateProperties.LIT);
    }

    private void poweredLampBlockWithItem(Holder<? extends Block> block) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        ModelBuilder modelOff = this.models().cubeAll(blockId.getPath(), this.getBlockTexture(block));
        ModelBuilder modelOn = this.models().cubeAll(blockId.getPath() + "_on", this.getBlockTexture(block, "_on"));
        VariantBlockStateBuilder blockStateBuilder = (VariantBlockStateBuilder)this.getVariantBuilder((Block)block.value()).partialState().with((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(0)).modelForState().modelFile((ModelFile)modelOff).addModel();
        for (int i = 1; i < 16; ++i) {
            blockStateBuilder.partialState().with((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)modelOn).addModel();
        }
        this.simpleBlockItem((Block)block.value(), (ModelFile)modelOff);
    }

    private ResourceLocation getBlockTexture(Holder<? extends Block> block) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        return ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)("block/" + blockId.getPath()));
    }

    private ResourceLocation getBlockTexture(Holder<? extends Block> block, String pathSuffix) {
        ResourceLocation blockId = Objects.requireNonNull(block.getKey()).location();
        return ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)("block/" + blockId.getPath() + pathSuffix));
    }
}

