/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.config.value;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.config.ConfigValidationException;
import me.jddev0.ep.config.ConfigValue;
import me.jddev0.ep.config.validation.ValueValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongConfigValue
extends ConfigValue<Long> {
    private final long minInclusive;
    private final boolean minLenCheckEnabled;
    private final long maxInclusive;
    private final boolean maxLenCheckEnabled;

    public LongConfigValue(@NotNull String key, @NotNull Long defaultValue) {
        this(key, (String)null, defaultValue);
    }

    public LongConfigValue(@NotNull String key, @Nullable String comment, @NotNull Long defaultValue) {
        this(key, comment, defaultValue, (ValueValidator<? super Long>)null);
    }

    public LongConfigValue(@NotNull String key, @Nullable String comment, @NotNull Long defaultValue, @Nullable ValueValidator<? super Long> customValidator) {
        this(key, comment, defaultValue, customValidator, null, null);
    }

    public LongConfigValue(@NotNull String key, @Nullable String comment, @NotNull Long defaultValue, @Nullable Long minInclusive, @Nullable Long maxInclusive) {
        this(key, comment, defaultValue, null, minInclusive, maxInclusive);
    }

    public LongConfigValue(@NotNull String key, @Nullable String comment, @NotNull Long defaultValue, @Nullable ValueValidator<? super Long> customValidator, @Nullable Long minInclusive, @Nullable Long maxInclusive) {
        super(key, comment, defaultValue, customValidator);
        this.minLenCheckEnabled = minInclusive != null;
        this.minInclusive = this.minLenCheckEnabled ? minInclusive : 0L;
        this.maxLenCheckEnabled = maxInclusive != null;
        this.maxInclusive = this.maxLenCheckEnabled ? maxInclusive : 0L;
    }

    @Override
    @NotNull
    public List<String> getValidationCommentLines() {
        ArrayList<String> commentLines = new ArrayList<String>();
        if (this.minLenCheckEnabled) {
            commentLines.add("Value >= " + this.minInclusive);
        }
        if (this.maxLenCheckEnabled) {
            commentLines.add("Value <= " + this.maxInclusive);
        }
        commentLines.addAll(super.getValidationCommentLines());
        return commentLines;
    }

    @Override
    public void validate(@NotNull Long value) throws ConfigValidationException {
        if (this.minLenCheckEnabled && value < this.minInclusive) {
            throw new ConfigValidationException("The value must be at least " + this.minInclusive);
        }
        if (this.maxLenCheckEnabled && value > this.maxInclusive) {
            throw new ConfigValidationException("The value must be at most " + this.maxInclusive);
        }
        super.validate(value);
    }

    @Override
    @NotNull
    protected Long readInternal(@NotNull String rawValue) throws ConfigValidationException {
        try {
            return Long.parseLong(rawValue);
        }
        catch (NumberFormatException e) {
            throw new ConfigValidationException("Invalid long value: " + e.getMessage());
        }
    }

    @Override
    @NotNull
    protected String writeInternal(@NotNull Long value) {
        return "" + value;
    }
}

