/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.FluidTankBlock;
import me.jddev0.ep.block.entity.AbstractFluidTankBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class FluidTankBlockEntityRenderer
implements BlockEntityRenderer<AbstractFluidTankBlockEntity<?>> {
    private final BlockEntityRendererProvider.Context context;

    public FluidTankBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(AbstractFluidTankBlockEntity<?> blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int capacity = blockEntity.getTankCapacity(0);
        FluidStack fluidStack = blockEntity.getFluid(0);
        if (fluidStack.isEmpty()) {
            return;
        }
        float height = fluidStack.getAmount() <= 0 || capacity == 0 ? 0.0f : (float)Math.min(fluidStack.getAmount(), capacity - 1) * 14.0f / (float)capacity;
        Direction facing = (Direction)blockEntity.getBlockState().getValue((Property)FluidTankBlock.FACING);
        poseStack.pushPose();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(Sheets.translucentCullBlockSheet());
        poseStack.mulPose(facing.getRotation());
        poseStack.mulPose(new Quaternionf().rotationX(1.5707964f));
        switch (facing) {
            case NORTH: {
                poseStack.translate(-1.0f, -1.0f + (16.0f - height - 1.0f) / 16.0f, 0.0625f);
                break;
            }
            case SOUTH: {
                poseStack.translate(0.0f, -1.0f + (16.0f - height - 1.0f) / 16.0f, -0.9375f);
                break;
            }
            case EAST: {
                poseStack.translate(-1.0f, -1.0f + (16.0f - height - 1.0f) / 16.0f, -0.9375f);
                break;
            }
            case WEST: {
                poseStack.translate(0.0f, -1.0f + (16.0f - height - 1.0f) / 16.0f, 0.0625f);
                break;
            }
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation stillFluidImageId = fluidTypeExtensions.getStillTexture(fluidStack);
        if (stillFluidImageId == null) {
            stillFluidImageId = ResourceLocation.withDefaultNamespace((String)"air");
        }
        TextureAtlasSprite stillFluidSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillFluidImageId);
        int fluidColorTint = fluidTypeExtensions.getTintColor(fluidStack);
        Matrix4f mat = poseStack.last().pose();
        float u0 = stillFluidSprite.getU0();
        float u1 = stillFluidSprite.getU1();
        float v0 = stillFluidSprite.getV0();
        float v1 = stillFluidSprite.getV1();
        float du = u1 - u0;
        float dv = v1 - v0;
        v0 += 0.0625f * dv;
        float v1Orig = v1 -= 0.0625f * dv;
        vertexConsumer.addVertex(mat, 0.0625f, height * 0.0625f, 0.0f).setColor(fluidColorTint).setUv(u0 += 0.0625f * du, v1 -= (14.0f - height) / 16.0f * dv).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(mat, 0.9375f, height * 0.0625f, 0.0f).setColor(fluidColorTint).setUv(u1 -= 0.0625f * du, v1).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(mat, 0.9375f, 0.0f, 0.0f).setColor(fluidColorTint).setUv(u1, v0).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(mat, 0.0625f, 0.0f, 0.0f).setColor(fluidColorTint).setUv(u0, v0).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        TextureAtlasSprite indicatorBarSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(EPAPI.id("block/fluid_tank_indicator_bar"));
        float translateForMinMaxIndicatorBarHeight = height < 2.0f ? (height - 2.0f) / 16.0f : (height > 12.0f ? (height - 12.0f) / 16.0f : 0.0f);
        poseStack.translate(0.0f, translateForMinMaxIndicatorBarHeight, 0.0f);
        float ibu0 = indicatorBarSprite.getU0();
        float ibu1 = indicatorBarSprite.getU1();
        float ibv0 = indicatorBarSprite.getV0();
        float ibv1 = indicatorBarSprite.getV1();
        ibu1 = ibu0 + 0.0625f * (ibu1 - ibu0);
        ibv1 = ibv0 + 0.0625f * (ibv1 - ibv0);
        vertexConsumer.addVertex(mat, 0.375f, 0.015f, -0.05f).setColor(255, 255, 255, 255).setUv(ibu0, ibv1).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(mat, 0.625f, 0.015f, -0.05f).setColor(255, 255, 255, 255).setUv(ibu1, ibv1).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(mat, 0.625f, -0.015f, -0.05f).setColor(255, 255, 255, 255).setUv(ibu1, ibv0).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(mat, 0.375f, -0.015f, -0.05f).setColor(255, 255, 255, 255).setUv(ibu0, ibv0).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        poseStack.translate(0.0f, -translateForMinMaxIndicatorBarHeight, 0.0f);
        v1 = v1Orig;
        poseStack.translate(0.0f, 1.0f - (16.0f - height - 1.0f) / 16.0f, 0.0f);
        poseStack.mulPose(new Quaternionf().rotationX(-1.5707964f));
        poseStack.translate(0.0f, -0.875f, -1.0f + (16.0f - height - 1.0f) / 16.0f);
        vertexConsumer.addVertex(mat, 0.0625f, 0.875f, 0.0f).setColor(fluidColorTint).setUv(u0, v1).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(mat, 0.9375f, 0.875f, 0.0f).setColor(fluidColorTint).setUv(u1, v1).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(mat, 0.9375f, 0.0f, 0.0f).setColor(fluidColorTint).setUv(u1, v0).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(mat, 0.0625f, 0.0f, 0.0f).setColor(fluidColorTint).setUv(u0, v0).setOverlay(packedOverlay).setLight(0xF000F0).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        poseStack.popPose();
    }
}

