/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import me.jddev0.ep.block.UnchargerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ExtractOnlyEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.UnchargerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnchargerBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<ExtractOnlyEnergyStorage, ItemStackHandler> {
    private final IItemHandler itemHandlerSided;
    private int energyProductionLeft;

    public UnchargerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.UNCHARGER_ENTITY.get(), blockPos, blockState, "uncharger", ModConfigs.COMMON_UNCHARGER_CAPACITY.getValue(), ModConfigs.COMMON_UNCHARGER_TRANSFER_RATE.getValue(), 1, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> {
            if (i != 0) {
                return false;
            }
            ItemStack stack = this.itemHandler.getStackInSlot(i.intValue());
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null || !energyStorage.canExtract()) {
                return true;
            }
            return energyStorage.extractEnergy(((ExtractOnlyEnergyStorage)this.energyStorage).getMaxExtract(), true) == 0;
        });
        this.energyProductionLeft = -1;
    }

    @Override
    protected ExtractOnlyEnergyStorage initEnergyStorage() {
        return new ExtractOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * UnchargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxExtract() {
                return Math.max(1, (int)Math.ceil((double)this.maxExtract * UnchargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                UnchargerBlockEntity.this.setChanged();
                UnchargerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                UnchargerBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                    return energyStorage != null && energyStorage.canExtract();
                }
                return super.isItemValid(slot, stack);
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(UnchargerBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack) && (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack) || stack.getCapability(Capabilities.EnergyStorage.ITEM) != null && itemStack.getCapability(Capabilities.EnergyStorage.ITEM) != null))) {
                        UnchargerBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new EnergyValueContainerData(() -> this.hasRecipe() ? this.getEnergyProductionPerTick() : -1, value -> {}), new EnergyValueContainerData(() -> this.energyProductionLeft, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new UnchargerMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put("recipe.energy_production_left", (Tag)IntTag.valueOf((int)this.energyProductionLeft));
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.energyProductionLeft = nbt.getInt("recipe.energy_production_left");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, UnchargerBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (blockEntity.redstoneMode.isActive((Boolean)state.getValue((Property)UnchargerBlock.POWERED))) {
            UnchargerBlockEntity.tickRecipe(level, blockPos, state, blockEntity);
        }
        UnchargerBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    protected final int getEnergyProductionPerTick() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null || !energyStorage.canExtract()) {
            return -1;
        }
        return energyStorage.extractEnergy(Math.max(0, Math.min(((ExtractOnlyEnergyStorage)this.energyStorage).getMaxExtract(), ((ExtractOnlyEnergyStorage)this.energyStorage).getCapacity() - ((ExtractOnlyEnergyStorage)this.energyStorage).getEnergy())), true);
    }

    private static void tickRecipe(Level level, BlockPos blockPos, BlockState state, UnchargerBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (blockEntity.hasRecipe()) {
            ItemStack stack = blockEntity.itemHandler.getStackInSlot(0);
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null || !energyStorage.canExtract()) {
                return;
            }
            blockEntity.energyProductionLeft = energyStorage.getEnergyStored();
            int energyProductionPerTick = energyStorage.extractEnergy(Math.max(0, Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getCapacity() - ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy())), false);
            if (blockEntity.energyProductionLeft < 0 || energyProductionPerTick < 0) {
                blockEntity.resetProgress();
                UnchargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                return;
            }
            ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() + energyProductionPerTick);
            blockEntity.energyProductionLeft -= energyProductionPerTick;
            if (blockEntity.energyProductionLeft <= 0) {
                blockEntity.resetProgress();
            }
            UnchargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        } else {
            blockEntity.resetProgress();
            UnchargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private static void transferEnergy(Level level, BlockPos blockPos, BlockState state, UnchargerBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        ArrayList<IEnergyStorage> consumerItems = new ArrayList<IEnergyStorage>();
        ArrayList<Integer> consumerEnergyValues = new ArrayList<Integer>();
        int consumptionSum = 0;
        for (Direction direction : Direction.values()) {
            int received;
            BlockPos testPos = blockPos.relative(direction);
            BlockEntity testBlockEntity = level.getBlockEntity(testPos);
            IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, testPos, level.getBlockState(testPos), testBlockEntity, (Object)direction.getOpposite());
            if (energyStorage == null || !energyStorage.canReceive() || (received = energyStorage.receiveEnergy(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()), true)) <= 0) continue;
            consumptionSum += received;
            consumerItems.add(energyStorage);
            consumerEnergyValues.add(received);
        }
        ArrayList<Integer> consumerEnergyDistributed = new ArrayList<Integer>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0);
        }
        int consumptionLeft = Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy(), consumptionSum));
        ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).extractEnergy(consumptionLeft, false);
        int divisor = consumerItems.size();
        block2: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block2;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
    }

    private void resetProgress() {
        this.energyProductionLeft = -1;
    }

    private boolean hasRecipe() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        return stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }
}

