/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import me.jddev0.ep.block.ConfigurableTransformerBlock;
import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.TransformerBlock;
import me.jddev0.ep.block.entity.base.ConfigurableEnergyStorageBlockEntity;
import me.jddev0.ep.energy.ReceiveAndExtractEnergyStorage;
import me.jddev0.ep.energy.ReceiveExtractEnergyHandler;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.tier.TransformerTier;
import me.jddev0.ep.machine.tier.TransformerType;
import me.jddev0.ep.screen.TransformerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class TransformerBlockEntity
extends ConfigurableEnergyStorageBlockEntity<ReceiveAndExtractEnergyStorage> {
    private final TransformerTier tier;
    private final TransformerType type;
    private final IEnergyStorage energyStorageSidedReceive;
    private final IEnergyStorage energyStorageSidedExtract;

    public TransformerBlockEntity(BlockPos blockPos, BlockState blockState, TransformerTier tier, TransformerType type) {
        super(tier.getEntityTypeFromTierAndType(type), blockPos, blockState, tier.getMachineNameFromTierAndType(type), tier.getMaxEnergyTransferFromTier(), tier.getMaxEnergyTransferFromTier());
        this.tier = tier;
        this.type = type;
        this.energyStorageSidedReceive = new ReceiveExtractEnergyHandler(this.energyStorage, (maxReceive, simulate) -> true, (maxExtract, simulate) -> false);
        this.energyStorageSidedExtract = new ReceiveExtractEnergyHandler(this.energyStorage, (maxReceive, simulate) -> false, (maxExtract, simulate) -> true);
    }

    @Override
    protected ReceiveAndExtractEnergyStorage initEnergyStorage() {
        return new ReceiveAndExtractEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            protected void onChange() {
                TransformerBlockEntity.this.setChanged();
                TransformerBlockEntity.this.syncEnergyToPlayers(32);
            }

            @Override
            public int extractEnergy(int maxExtract, boolean simulate) {
                if (TransformerBlockEntity.this.level != null && !TransformerBlockEntity.this.redstoneMode.isActive((Boolean)TransformerBlockEntity.this.level.getBlockState(TransformerBlockEntity.this.getBlockPos()).getValue((Property)BlockStateProperties.POWERED))) {
                    return 0;
                }
                return super.extractEnergy(maxExtract, simulate);
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new TransformerMenu(id, inventory, this, this.data);
    }

    public TransformerType getTransformerType() {
        return this.type;
    }

    public TransformerTier getTier() {
        return this.tier;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        if (side == null) {
            return this.energyStorage;
        }
        if (this.type == TransformerType.CONFIGURABLE) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            EPBlockStateProperties.TransformerConnection transformerConnection = (EPBlockStateProperties.TransformerConnection)((Object)state.getValue(ConfigurableTransformerBlock.getTransformerConnectionPropertyFromDirection(side)));
            return switch (transformerConnection) {
                default -> throw new MatchException(null, null);
                case EPBlockStateProperties.TransformerConnection.NOT_CONNECTED -> null;
                case EPBlockStateProperties.TransformerConnection.RECEIVE -> this.energyStorageSidedReceive;
                case EPBlockStateProperties.TransformerConnection.EXTRACT -> this.energyStorageSidedExtract;
            };
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)TransformerBlock.FACING);
        switch (this.type) {
            case TYPE_1_TO_N: 
            case TYPE_N_TO_1: {
                IEnergyStorage multipleSide;
                IEnergyStorage singleSide = this.type == TransformerType.TYPE_1_TO_N ? this.energyStorageSidedReceive : this.energyStorageSidedExtract;
                IEnergyStorage iEnergyStorage = multipleSide = this.type == TransformerType.TYPE_1_TO_N ? this.energyStorageSidedExtract : this.energyStorageSidedReceive;
                if (facing == side) {
                    return singleSide;
                }
                return multipleSide;
            }
            case TYPE_3_TO_3: {
                if (facing.getCounterClockWise(Direction.Axis.X) == side || facing.getCounterClockWise(Direction.Axis.Y) == side || facing.getCounterClockWise(Direction.Axis.Z) == side) {
                    return this.energyStorageSidedReceive;
                }
                return this.energyStorageSidedExtract;
            }
        }
        return null;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, TransformerBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        TransformerBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferEnergy(Level level, BlockPos blockPos, BlockState state, TransformerBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.getValue((Property)BlockStateProperties.POWERED))) {
            return;
        }
        ArrayList<Direction> outputDirections = new ArrayList<Direction>();
        if (blockEntity.type == TransformerType.CONFIGURABLE) {
            for (Direction side : Direction.values()) {
                EPBlockStateProperties.TransformerConnection transformerConnection = (EPBlockStateProperties.TransformerConnection)((Object)state.getValue(ConfigurableTransformerBlock.getTransformerConnectionPropertyFromDirection(side)));
                if (!transformerConnection.isExtract()) continue;
                outputDirections.add(side);
            }
        } else {
            Direction facing = (Direction)state.getValue((Property)TransformerBlock.FACING);
            block5: for (Direction side : Direction.values()) {
                switch (blockEntity.getTransformerType()) {
                    case TYPE_1_TO_N: 
                    case TYPE_N_TO_1: {
                        boolean isOutputMultipleSide;
                        boolean isOutputSingleSide = blockEntity.getTransformerType() != TransformerType.TYPE_1_TO_N;
                        boolean bl = isOutputMultipleSide = blockEntity.getTransformerType() == TransformerType.TYPE_1_TO_N;
                        if (facing == side) {
                            if (!isOutputSingleSide) continue block5;
                            outputDirections.add(side);
                            continue block5;
                        }
                        if (!isOutputMultipleSide) continue block5;
                        outputDirections.add(side);
                        continue block5;
                    }
                    case TYPE_3_TO_3: {
                        if (facing.getCounterClockWise(Direction.Axis.X) == side || facing.getCounterClockWise(Direction.Axis.Y) == side || facing.getCounterClockWise(Direction.Axis.Z) == side) continue block5;
                        outputDirections.add(side);
                    }
                }
            }
        }
        ArrayList<IEnergyStorage> consumerItems = new ArrayList<IEnergyStorage>();
        ArrayList<Integer> consumerEnergyValues = new ArrayList<Integer>();
        int consumptionSum = 0;
        for (Direction direction : outputDirections) {
            int received;
            BlockPos testPos = blockPos.relative(direction);
            BlockEntity testBlockEntity = level.getBlockEntity(testPos);
            IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, testPos, level.getBlockState(testPos), testBlockEntity, (Object)direction.getOpposite());
            if (energyStorage == null || !energyStorage.canReceive() || (received = energyStorage.receiveEnergy(Math.min(((ReceiveAndExtractEnergyStorage)blockEntity.energyStorage).getMaxTransfer(), ((ReceiveAndExtractEnergyStorage)blockEntity.energyStorage).getEnergy()), true)) <= 0) continue;
            consumptionSum += received;
            consumerItems.add(energyStorage);
            consumerEnergyValues.add(received);
        }
        ArrayList<Integer> consumerEnergyDistributed = new ArrayList<Integer>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0);
        }
        int consumptionLeft = Math.min(((ReceiveAndExtractEnergyStorage)blockEntity.energyStorage).getMaxTransfer(), Math.min(((ReceiveAndExtractEnergyStorage)blockEntity.energyStorage).getEnergy(), consumptionSum));
        ((ReceiveAndExtractEnergyStorage)blockEntity.energyStorage).extractEnergy(consumptionLeft, false);
        int divisor = consumerItems.size();
        block8: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block8;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
    }
}

