/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageMultiTankMethods;
import me.jddev0.ep.block.entity.base.SelectableRecipeFluidMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.fluid.EnergizedPowerFluidStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.StoneSolidifierRecipe;
import me.jddev0.ep.screen.StoneSolidifierMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneSolidifierBlockEntity
extends SelectableRecipeFluidMachineBlockEntity<EnergizedPowerFluidStorage, RecipeInput, StoneSolidifierRecipe> {
    public static final int TANK_CAPACITY = 1000 * ModConfigs.COMMON_STONE_SOLIDIFIER_TANK_CAPACITY.getValue();
    private final IItemHandler itemHandlerSided;

    public StoneSolidifierBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.STONE_SOLIDIFIER_ENTITY.get(), blockPos, blockState, "stone_solidifier", StoneSolidifierMenu::new, 1, EPRecipes.STONE_SOLIDIFIER_TYPE.get(), EPRecipes.STONE_SOLIDIFIER_SERIALIZER.get(), (int)ModConfigs.COMMON_STONE_SOLIDIFIER_RECIPE_DURATION.getValue(), ModConfigs.COMMON_STONE_SOLIDIFIER_CAPACITY.getValue(), (int)ModConfigs.COMMON_STONE_SOLIDIFIER_TRANSFER_RATE.getValue(), ModConfigs.COMMON_STONE_SOLIDIFIER_CONSUMPTION_PER_TICK.getValue(), FluidStorageMultiTankMethods.INSTANCE, TANK_CAPACITY, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> false, i -> i == 0);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                StoneSolidifierBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }
        };
    }

    @Override
    protected EnergizedPowerFluidStorage initFluidStorage() {
        return new EnergizedPowerFluidStorage(new int[]{this.baseTankCapacity, this.baseTankCapacity}){

            @Override
            protected void onContentsChanged() {
                StoneSolidifierBlockEntity.this.setChanged();
                StoneSolidifierBlockEntity.this.syncFluidToPlayers(32);
            }

            @Override
            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                if (!super.isFluidValid(tank, stack)) {
                    return false;
                }
                return switch (tank) {
                    case 0 -> FluidStack.isSameFluid((FluidStack)stack, (FluidStack)new FluidStack((Fluid)Fluids.WATER, 1));
                    case 1 -> FluidStack.isSameFluid((FluidStack)stack, (FluidStack)new FluidStack((Fluid)Fluids.LAVA, 1));
                    default -> false;
                };
            }
        };
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IFluidHandler getFluidHandlerCapability(@Nullable Direction side) {
        return this.fluidStorage;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void craftItem(RecipeHolder<StoneSolidifierRecipe> recipe) {
        if (this.level == null || !this.hasRecipe()) {
            return;
        }
        ((EnergizedPowerFluidStorage)this.fluidStorage).drain(new FluidStack((Fluid)Fluids.WATER, ((StoneSolidifierRecipe)recipe.value()).getWaterAmount()), IFluidHandler.FluidAction.EXECUTE);
        ((EnergizedPowerFluidStorage)this.fluidStorage).drain(new FluidStack((Fluid)Fluids.LAVA, ((StoneSolidifierRecipe)recipe.value()).getLavaAmount()), IFluidHandler.FluidAction.EXECUTE);
        this.itemHandler.setStackInSlot(0, ((StoneSolidifierRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).copyWithCount(this.itemHandler.getStackInSlot(0).getCount() + ((StoneSolidifierRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).getCount()));
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, RecipeHolder<StoneSolidifierRecipe> recipe) {
        return this.level != null && ((EnergizedPowerFluidStorage)this.fluidStorage).getFluid(0).getAmount() >= ((StoneSolidifierRecipe)recipe.value()).getWaterAmount() && ((EnergizedPowerFluidStorage)this.fluidStorage).getFluid(1).getAmount() >= ((StoneSolidifierRecipe)recipe.value()).getLavaAmount() && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 0, ((StoneSolidifierRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()));
    }
}

