/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.base.UpgradableEnergyStorageBlockEntity;
import me.jddev0.ep.energy.ExtractOnlyEnergyStorage;
import me.jddev0.ep.machine.tier.SolarPanelTier;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.SolarPanelMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class SolarPanelBlockEntity
extends UpgradableEnergyStorageBlockEntity<ExtractOnlyEnergyStorage> {
    private final SolarPanelTier tier;

    public SolarPanelBlockEntity(BlockPos blockPos, BlockState blockState, SolarPanelTier tier) {
        super(tier.getEntityTypeFromTier(), blockPos, blockState, tier.getResourceId(), tier.getCapacity(), tier.getMaxTransfer(), UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.MOON_LIGHT);
        this.tier = tier;
    }

    @Override
    protected ExtractOnlyEnergyStorage initEnergyStorage() {
        return new ExtractOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * SolarPanelBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxExtract() {
                return Math.max(1, (int)Math.ceil((double)this.maxExtract * SolarPanelBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                SolarPanelBlockEntity.this.setChanged();
                SolarPanelBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new SolarPanelMenu(id, inventory, this, this.upgradeModuleInventory);
    }

    public SolarPanelTier getTier() {
        return this.tier;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, SolarPanelBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        int i = 4 * (level.getBrightness(LightLayer.SKY, blockPos) - level.getSkyDarken());
        float f = level.getSunAngle(1.0f);
        if (i > 0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            i = Math.round((float)i * Mth.cos((float)f));
        }
        i = Mth.clamp((int)i, (int)0, (int)60);
        int energyProduction = (int)((float)i / 60.0f * (float)blockEntity.getTier().getPeakFePerTick());
        double moonLightUpgradeModuleEffect = blockEntity.upgradeModuleInventory.getUpgradeModuleModifierEffect(1, UpgradeModuleModifier.MOON_LIGHT);
        if (moonLightUpgradeModuleEffect > 0.0 && (i = 15 - (level.getBrightness(LightLayer.SKY, blockPos) - level.getSkyDarken())) < 14) {
            i = Mth.clamp((int)i, (int)0, (int)15);
            energyProduction += (int)((double)i / 15.0 * (double)blockEntity.getTier().getPeakFePerTick() * moonLightUpgradeModuleEffect);
        }
        ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getCapacity(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() + energyProduction));
        SolarPanelBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferEnergy(Level level, BlockPos blockPos, BlockState state, SolarPanelBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        BlockPos testPos = blockPos.relative(Direction.DOWN);
        BlockEntity testBlockEntity = level.getBlockEntity(testPos);
        IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, testPos, level.getBlockState(testPos), testBlockEntity, (Object)Direction.DOWN.getOpposite());
        if (energyStorage == null || !energyStorage.canReceive()) {
            return;
        }
        int amount = energyStorage.receiveEnergy(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract()), false);
        if (amount > 0) {
            ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).extractEnergy(amount, false);
        }
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        if (side == null || side == Direction.DOWN) {
            return this.energyStorage;
        }
        return null;
    }
}

