/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.MenuInventoryStorageBlockEntity;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncPressMoldMakerRecipeListS2CPacket;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.PressMoldMakerRecipe;
import me.jddev0.ep.screen.PressMoldMakerMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PressMoldMakerBlockEntity
extends MenuInventoryStorageBlockEntity<ItemStackHandler> {
    private List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> recipeList = new ArrayList<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>>();
    private final IItemHandler itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1);

    public PressMoldMakerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.PRESS_MOLD_MAKER_ENTITY.get(), blockPos, blockState, "press_mold_maker", 2);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                PressMoldMakerBlockEntity.this.setChanged();
                if (slot == 0 && PressMoldMakerBlockEntity.this.level != null && !PressMoldMakerBlockEntity.this.level.isClientSide()) {
                    List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> recipeList = PressMoldMakerBlockEntity.this.createRecipeList();
                    ModMessages.sendToPlayersWithinXBlocks(new SyncPressMoldMakerRecipeListS2CPacket(PressMoldMakerBlockEntity.this.getBlockPos(), recipeList), PressMoldMakerBlockEntity.this.getBlockPos(), (ServerLevel)PressMoldMakerBlockEntity.this.level, 32);
                }
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (PressMoldMakerBlockEntity.this.level == null || stack.is(Items.CLAY_BALL)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }
        };
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> recipeList = this.createRecipeList();
        ModMessages.sendToPlayer(new SyncPressMoldMakerRecipeListS2CPacket(this.getBlockPos(), recipeList), (ServerPlayer)player);
        return new PressMoldMakerMenu(id, inventory, this);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    public void craftItem(ResourceLocation recipeId) {
        Recipe recipe;
        Optional<RecipeHolder> recipe2 = this.level.getRecipeManager().getRecipes().stream().filter(recipeHolder -> recipeHolder.id().equals((Object)recipeId)).findFirst();
        if (recipe2.isEmpty() || !((recipe = recipe2.get().value()) instanceof PressMoldMakerRecipe)) {
            return;
        }
        PressMoldMakerRecipe pressMoldMakerRecipe = (PressMoldMakerRecipe)recipe;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        if (!pressMoldMakerRecipe.matches(new ContainerRecipeInputWrapper((Container)inventory), this.level) || !InventoryUtils.canInsertItemIntoSlot((Container)inventory, 1, pressMoldMakerRecipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()))) {
            return;
        }
        this.itemHandler.extractItem(0, pressMoldMakerRecipe.getClayCount(), false);
        this.itemHandler.setStackInSlot(1, pressMoldMakerRecipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()).copyWithCount(this.itemHandler.getStackInSlot(1).getCount() + pressMoldMakerRecipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()).getCount()));
    }

    private List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> createRecipeList() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        List recipes = this.level.getRecipeManager().getAllRecipesFor((RecipeType)PressMoldMakerRecipe.Type.INSTANCE);
        return recipes.stream().sorted(Comparator.comparing(recipe -> ((PressMoldMakerRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).getDescriptionId())).map(recipe -> Pair.of((Object)recipe, (Object)((PressMoldMakerRecipe)recipe.value()).matches(new ContainerRecipeInputWrapper((Container)inventory), this.level))).collect(Collectors.toList());
    }

    public List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> getRecipeList() {
        return this.recipeList;
    }

    public void setRecipeList(List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> recipeList) {
        this.recipeList = recipeList;
    }
}

