/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.block.MinecartUnchargerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.MenuEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ExtractOnlyEnergyStorage;
import me.jddev0.ep.entity.AbstractMinecartBatteryBox;
import me.jddev0.ep.screen.MinecartUnchargerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class MinecartUnchargerBlockEntity
extends MenuEnergyStorageBlockEntity<ExtractOnlyEnergyStorage> {
    public static final int MAX_TRANSFER = ModConfigs.COMMON_MINECART_UNCHARGER_TRANSFER_RATE.getValue();
    private boolean hasMinecartOld = true;
    private boolean hasMinecart = false;

    public MinecartUnchargerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.MINECART_UNCHARGER_ENTITY.get(), blockPos, blockState, "minecart_uncharger", ModConfigs.COMMON_MINECART_UNCHARGER_CAPACITY.getValue(), MAX_TRANSFER);
    }

    @Override
    protected ExtractOnlyEnergyStorage initEnergyStorage() {
        return new ExtractOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            protected void onChange() {
                MinecartUnchargerBlockEntity.this.setChanged();
                MinecartUnchargerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new MinecartUnchargerMenu(id, inventory, this);
    }

    public int getRedstoneOutput() {
        BlockPos blockPosFacing = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)MinecartUnchargerBlock.FACING));
        List minecarts = this.level.getEntities(EntityTypeTest.forClass(AbstractMinecartBatteryBox.class), new AABB((double)blockPosFacing.getX(), (double)blockPosFacing.getY(), (double)blockPosFacing.getZ(), (double)(blockPosFacing.getX() + 1), (double)(blockPosFacing.getY() + 1), (double)(blockPosFacing.getZ() + 1)), EntitySelector.ENTITY_STILL_ALIVE);
        if (minecarts.isEmpty()) {
            return 0;
        }
        AbstractMinecartBatteryBox minecart = (AbstractMinecartBatteryBox)((Object)minecarts.get(0));
        int minecartEnergy = minecart.getEnergy();
        boolean isEmptyFlag = minecartEnergy == 0;
        return Math.min(Mth.floor((float)((float)minecartEnergy / (float)minecart.getCapacity() * 14.0f)) + (isEmptyFlag ? 0 : 1), 15);
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, MinecartUnchargerBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (blockEntity.hasMinecartOld != blockEntity.hasMinecart) {
            MinecartUnchargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
        blockEntity.hasMinecartOld = blockEntity.hasMinecart;
        BlockPos blockPosFacing = blockEntity.getBlockPos().relative((Direction)blockEntity.getBlockState().getValue((Property)MinecartUnchargerBlock.FACING));
        List minecarts = level.getEntities(EntityTypeTest.forClass(AbstractMinecartBatteryBox.class), new AABB((double)blockPosFacing.getX(), (double)blockPosFacing.getY(), (double)blockPosFacing.getZ(), (double)(blockPosFacing.getX() + 1), (double)(blockPosFacing.getY() + 1), (double)(blockPosFacing.getZ() + 1)), EntitySelector.ENTITY_STILL_ALIVE);
        boolean bl = blockEntity.hasMinecart = !minecarts.isEmpty();
        if (!blockEntity.hasMinecart) {
            return;
        }
        AbstractMinecartBatteryBox minecart = (AbstractMinecartBatteryBox)((Object)minecarts.get(0));
        int transferred = Math.max(0, Math.min(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getCapacity() - ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract()), Math.min(minecart.getTransferRate(), minecart.getEnergy())));
        minecart.setEnergy(minecart.getEnergy() - transferred);
        ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() + transferred);
        MinecartUnchargerBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferEnergy(Level level, BlockPos blockPos, BlockState state, MinecartUnchargerBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        ArrayList<IEnergyStorage> consumerItems = new ArrayList<IEnergyStorage>();
        ArrayList<Integer> consumerEnergyValues = new ArrayList<Integer>();
        int consumptionSum = 0;
        for (Direction direction : Direction.values()) {
            int received;
            BlockPos testPos = blockPos.relative(direction);
            BlockEntity testBlockEntity = level.getBlockEntity(testPos);
            IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, testPos, level.getBlockState(testPos), testBlockEntity, (Object)direction.getOpposite());
            if (energyStorage == null || !energyStorage.canReceive() || (received = energyStorage.receiveEnergy(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()), true)) <= 0) continue;
            consumptionSum += received;
            consumerItems.add(energyStorage);
            consumerEnergyValues.add(received);
        }
        ArrayList<Integer> consumerEnergyDistributed = new ArrayList<Integer>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0);
        }
        int consumptionLeft = Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy(), consumptionSum));
        ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).extractEnergy(consumptionLeft, false);
        int divisor = consumerItems.size();
        block2: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block2;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
    }
}

