/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.ItemConveyorBeltSplitterBlock;
import me.jddev0.ep.block.entity.ItemConveyorBeltBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.machine.tier.ConveyorBeltTier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ItemConveyorBeltSplitterBlockEntity
extends BlockEntity {
    private final int ticksPerItem;
    private int currentOutputIndex;
    private final ConveyorBeltTier tier;

    public ItemConveyorBeltSplitterBlockEntity(BlockPos blockPos, BlockState blockState, ConveyorBeltTier tier) {
        super(tier.getItemConveyorBeltSplitterBlockEntityFromTier(), blockPos, blockState);
        this.tier = tier;
        this.ticksPerItem = switch (tier) {
            default -> throw new MatchException(null, null);
            case ConveyorBeltTier.BASIC -> ModConfigs.COMMON_BASIC_ITEM_CONVEYOR_BELT_SPLITTER_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.FAST -> ModConfigs.COMMON_FAST_ITEM_CONVEYOR_BELT_SPLITTER_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.EXPRESS -> ModConfigs.COMMON_EXPRESS_ITEM_CONVEYOR_BELT_SPLITTER_TICKS_PER_ITEM.getValue();
        };
    }

    public ConveyorBeltTier getTier() {
        return this.tier;
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("current_output_index", this.currentOutputIndex);
    }

    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.currentOutputIndex = nbt.getInt("current_output_index");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltSplitterBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (level.getGameTime() % (long)blockEntity.ticksPerItem == 0L) {
            Direction facing = (Direction)state.getValue((Property)ItemConveyorBeltSplitterBlock.FACING);
            BlockPos inputPos = blockPos.relative(facing);
            BlockState inputBlockState = level.getBlockState(inputPos);
            if (!(inputBlockState.getBlock() instanceof ItemConveyorBeltBlock)) {
                return;
            }
            EPBlockStateProperties.ConveyorBeltDirection inputBeltFacing = (EPBlockStateProperties.ConveyorBeltDirection)((Object)inputBlockState.getValue(ItemConveyorBeltBlock.FACING));
            if (inputBeltFacing.isAscending() || inputBeltFacing.getDirection().getOpposite() != facing) {
                return;
            }
            BlockEntity inputBlockEntity = level.getBlockEntity(inputPos);
            if (!(inputBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
                return;
            }
            IItemHandler inputBeltItemStackStorage = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, inputPos, inputBlockState, inputBlockEntity, (Object)facing.getOpposite());
            if (inputBeltItemStackStorage == null) {
                return;
            }
            ItemStack itemStackToSwitch = inputBeltItemStackStorage.getStackInSlot(inputBeltItemStackStorage.getSlots() - 1);
            if (itemStackToSwitch.isEmpty()) {
                return;
            }
            for (int j = 0; j < 3; ++j) {
                IItemHandler outputBeltItemStackStorage;
                BlockEntity outputBlockEntity;
                Direction outputDirection;
                int index = (blockEntity.currentOutputIndex + j) % 3;
                switch (index) {
                    case 0: {
                        Direction direction = facing.getClockWise();
                        break;
                    }
                    case 1: {
                        Direction direction = facing.getOpposite();
                        break;
                    }
                    case 2: {
                        Direction direction = facing.getCounterClockWise();
                        break;
                    }
                    default: {
                        Direction direction = outputDirection = null;
                    }
                }
                if (outputDirection == null) {
                    return;
                }
                BlockPos outputPos = blockPos.relative(outputDirection);
                BlockState outputBlockState = level.getBlockState(outputPos);
                if (!(outputBlockState.getBlock() instanceof ItemConveyorBeltBlock) || !((outputBlockEntity = level.getBlockEntity(outputPos)) instanceof ItemConveyorBeltBlockEntity) || (outputBeltItemStackStorage = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, outputPos, outputBlockState, outputBlockEntity, (Object)outputDirection.getOpposite())) == null) continue;
                for (int i = 0; i < outputBeltItemStackStorage.getSlots(); ++i) {
                    if (!outputBeltItemStackStorage.insertItem(i, itemStackToSwitch, false).isEmpty()) continue;
                    inputBeltItemStackStorage.extractItem(inputBeltItemStackStorage.getSlots() - 1, 1, false);
                    blockEntity.currentOutputIndex = (index + 1) % 3;
                    ItemConveyorBeltSplitterBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
            }
        }
    }
}

