/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.ItemConveyorBeltLoaderBlock;
import me.jddev0.ep.block.entity.ItemConveyorBeltBlockEntity;
import me.jddev0.ep.block.entity.base.MenuInventoryStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.tier.ConveyorBeltTier;
import me.jddev0.ep.screen.ItemConveyorBeltLoaderMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ItemConveyorBeltLoaderBlockEntity
extends MenuInventoryStorageBlockEntity<ItemStackHandler> {
    private final int ticksPerItem;
    private final IItemHandler itemHandlerSided;
    private final ConveyorBeltTier tier;

    public ItemConveyorBeltLoaderBlockEntity(BlockPos blockPos, BlockState blockState, ConveyorBeltTier tier) {
        BlockEntityType<ItemConveyorBeltLoaderBlockEntity> blockEntityType = tier.getItemConveyorBeltLoaderBlockEntityFromTier();
        super(blockEntityType, blockPos, blockState, switch (tier) {
            default -> throw new MatchException(null, null);
            case ConveyorBeltTier.BASIC -> "item_conveyor_belt_loader";
            case ConveyorBeltTier.FAST -> "fast_item_conveyor_belt_loader";
            case ConveyorBeltTier.EXPRESS -> "express_item_conveyor_belt_loader";
        }, 1);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 0);
        this.tier = tier;
        this.ticksPerItem = switch (tier) {
            default -> throw new MatchException(null, null);
            case ConveyorBeltTier.BASIC -> ModConfigs.COMMON_BASIC_ITEM_CONVEYOR_BELT_LOADER_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.FAST -> ModConfigs.COMMON_FAST_ITEM_CONVEYOR_BELT_LOADER_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.EXPRESS -> ModConfigs.COMMON_EXPRESS_ITEM_CONVEYOR_BELT_LOADER_TICKS_PER_ITEM.getValue();
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                ItemConveyorBeltLoaderBlockEntity.this.setChanged();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    public ConveyorBeltTier getTier() {
        return this.tier;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new ItemConveyorBeltLoaderMenu(id, inventory, this);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltLoaderBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (level.getGameTime() % (long)blockEntity.ticksPerItem == 0L && ((Boolean)state.getValue((Property)ItemConveyorBeltLoaderBlock.ENABLED)).booleanValue()) {
            if (!blockEntity.itemHandler.getStackInSlot(0).isEmpty()) {
                ItemConveyorBeltLoaderBlockEntity.insertItemStackIntoItemConveyorBelt(level, blockPos, state, blockEntity, blockEntity.itemHandler.getStackInSlot(0).copy());
            }
            if (blockEntity.itemHandler.getStackInSlot(0).isEmpty()) {
                ItemConveyorBeltLoaderBlockEntity.extractItemStackFromBlockEntity(level, blockPos, state, blockEntity);
            }
        }
    }

    private static void insertItemStackIntoItemConveyorBelt(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltLoaderBlockEntity blockEntity, ItemStack itemStackToInsert) {
        Direction direction = (Direction)blockEntity.getBlockState().getValue((Property)ItemConveyorBeltLoaderBlock.FACING);
        BlockPos testPos = blockPos.relative(direction);
        BlockState testBlockState = level.getBlockState(testPos);
        if (!(testBlockState.getBlock() instanceof ItemConveyorBeltBlock)) {
            return;
        }
        BlockEntity testBlockEntity = level.getBlockEntity(testPos);
        if (!(testBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
            return;
        }
        IItemHandler itemStackStorage = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, testPos, testBlockState, testBlockEntity, (Object)direction.getOpposite());
        if (itemStackStorage == null) {
            return;
        }
        for (int i = 0; i < itemStackStorage.getSlots(); ++i) {
            if (!itemStackStorage.insertItem(i, itemStackToInsert, false).isEmpty()) continue;
            blockEntity.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
            break;
        }
    }

    private static void extractItemStackFromBlockEntity(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltLoaderBlockEntity blockEntity) {
        Direction direction = ((Direction)blockEntity.getBlockState().getValue((Property)ItemConveyorBeltLoaderBlock.FACING)).getOpposite();
        BlockPos testPos = blockPos.relative(direction);
        BlockEntity testBlockEntity = level.getBlockEntity(testPos);
        IItemHandler itemStackStorage = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, testPos, level.getBlockState(testPos), testBlockEntity, (Object)direction.getOpposite());
        if (itemStackStorage == null) {
            return;
        }
        for (int i = 0; i < itemStackStorage.getSlots(); ++i) {
            ItemStack extracted = itemStackStorage.extractItem(i, 1, false);
            if (extracted.isEmpty()) continue;
            blockEntity.itemHandler.setStackInSlot(0, extracted);
            break;
        }
    }
}

