/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.AbstractFluidTankBlockEntity;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.tier.FluidTankTier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.FluidSyncS2CPacket;
import me.jddev0.ep.screen.FluidTankMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTankBlockEntity
extends AbstractFluidTankBlockEntity<FluidTank>
implements CheckboxUpdate {
    private final FluidTankTier tier;
    private boolean ignoreNBT;
    private FluidStack fluidFilter = FluidStack.EMPTY;

    public FluidTankBlockEntity(BlockPos blockPos, BlockState blockState, FluidTankTier tier) {
        super(tier.getEntityTypeFromTier(), blockPos, blockState, tier.getResourceId(), FluidStorageSingleTankMethods.INSTANCE, tier.getTankCapacity());
        this.tier = tier;
    }

    @Override
    protected FluidTank initFluidStorage() {
        return new FluidTank(this.baseTankCapacity){

            protected void onContentsChanged() {
                FluidTankBlockEntity.this.setChanged();
                FluidTankBlockEntity.this.syncFluidToPlayers(64);
            }

            public boolean isFluidValid(FluidStack stack) {
                if (!super.isFluidValid(stack)) {
                    return false;
                }
                return FluidTankBlockEntity.this.fluidFilter.isEmpty() || (FluidTankBlockEntity.this.ignoreNBT ? FluidTankBlockEntity.this.fluidFilter.getFluid().isSame(stack.getFluid()) : FluidStack.isSameFluidSameComponents((FluidStack)FluidTankBlockEntity.this.fluidFilter, (FluidStack)stack));
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new BooleanValueContainerData(() -> this.ignoreNBT, value -> {
            this.ignoreNBT = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncFluidToPlayer(player);
        ModMessages.sendToPlayer(new FluidSyncS2CPacket(1, this.fluidFilter, 0, this.worldPosition), (ServerPlayer)player);
        return new FluidTankMenu(id, inventory, this, this.data);
    }

    public FluidTankTier getTier() {
        return this.tier;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putBoolean("ignore_nbt", this.ignoreNBT);
        nbt.put("fluid_filter", this.fluidFilter.saveOptional(registries));
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.ignoreNBT = nbt.getBoolean("ignore_nbt");
        this.fluidFilter = FluidStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("fluid_filter"));
    }

    public void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
        FluidTankBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setIgnoreNBT(checked);
            }
        }
    }

    public void setFluidFilter(FluidStack fluidFilter) {
        this.fluidFilter = fluidFilter.copy();
        FluidTankBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
        ModMessages.sendToPlayersWithinXBlocks(new FluidSyncS2CPacket(1, fluidFilter, 0, this.getBlockPos()), this.getBlockPos(), (ServerLevel)this.level, 64);
    }

    @Override
    public FluidStack getFluid(int tank) {
        return switch (tank) {
            case 0 -> super.getFluid(tank);
            case 1 -> this.fluidFilter;
            default -> null;
        };
    }

    @Override
    public int getTankCapacity(int tank) {
        if (tank == 0) {
            return super.getTankCapacity(tank);
        }
        return 0;
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        switch (tank) {
            case 0: {
                super.setFluid(tank, fluidStack);
                break;
            }
            case 1: {
                this.fluidFilter = fluidStack.copy();
            }
        }
    }

    @Override
    public void setTankCapacity(int tank, int capacity) {
        if (tank == 0) {
            super.setTankCapacity(tank, capacity);
        }
    }
}

