/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.FluidFillerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryFluidEnergyStorageBlockEntity;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.FluidValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.FluidFillerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidFillerBlockEntity
extends ConfigurableUpgradableInventoryFluidEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler, FluidTank> {
    public static final int MAX_FLUID_FILLING_PER_TICK = ModConfigs.COMMON_FLUID_FILLER_FLUID_ITEM_TRANSFER_RATE.getValue();
    public static final int ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_FLUID_FILLER_ENERGY_CONSUMPTION_PER_TICK.getValue();
    private final IItemHandler itemHandlerSided;
    private int fluidFillingLeft;
    private int fluidFillingSumPending;

    public FluidFillerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.FLUID_FILLER_ENTITY.get(), blockPos, blockState, "fluid_filler", ModConfigs.COMMON_FLUID_FILLER_CAPACITY.getValue(), ModConfigs.COMMON_FLUID_FILLER_TRANSFER_RATE.getValue(), 1, FluidStorageSingleTankMethods.INSTANCE, ModConfigs.COMMON_FLUID_FILLER_FLUID_TANK_CAPACITY.getValue() * 1000, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> {
            if (i != 0) {
                return false;
            }
            ItemStack stack = this.itemHandler.getStackInSlot(i.intValue());
            IFluidHandlerItem fluidStorage = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidStorage == null) {
                return true;
            }
            for (int j = 0; j < fluidStorage.getTanks(); ++j) {
                FluidStack fluidStack = fluidStorage.getFluidInTank(j);
                if (fluidStorage.getTankCapacity(j) <= fluidStack.getAmount() || !((FluidTank)this.fluidStorage).isEmpty() && (!fluidStack.isEmpty() || !fluidStorage.isFluidValid(j, ((FluidTank)this.fluidStorage).getFluid())) && !FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)((FluidTank)this.fluidStorage).getFluid())) continue;
                return false;
            }
            return true;
        });
        this.fluidFillingLeft = -1;
        this.fluidFillingSumPending = 0;
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * FluidFillerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * FluidFillerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                FluidFillerBlockEntity.this.setChanged();
                FluidFillerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                FluidFillerBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return stack.getCapability(Capabilities.FluidHandler.ITEM) != null;
                }
                return super.isItemValid(slot, stack);
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(FluidFillerBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack) && (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack) || stack.getCapability(Capabilities.FluidHandler.ITEM) != null && itemStack.getCapability(Capabilities.FluidHandler.ITEM) != null))) {
                        FluidFillerBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    protected FluidTank initFluidStorage() {
        return new FluidTank(this.baseTankCapacity){

            protected void onContentsChanged() {
                FluidFillerBlockEntity.this.setChanged();
                FluidFillerBlockEntity.this.syncFluidToPlayers(32);
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new FluidValueContainerData(() -> this.fluidFillingLeft, value -> {}), new FluidValueContainerData(() -> this.fluidFillingSumPending, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        return new FluidFillerMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IFluidHandler getFluidHandlerCapability(@Nullable Direction side) {
        return this.fluidStorage;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put("recipe.fluid_filling_left", (Tag)IntTag.valueOf((int)this.fluidFillingLeft));
        nbt.put("recipe.fluid_filling_sum_pending", (Tag)IntTag.valueOf((int)this.fluidFillingSumPending));
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.fluidFillingLeft = nbt.getInt("recipe.fluid_filling_left");
        this.fluidFillingSumPending = nbt.getInt("recipe.fluid_filling_sum_pending");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, FluidFillerBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.getValue((Property)FluidFillerBlock.POWERED))) {
            return;
        }
        if (blockEntity.hasRecipe()) {
            ItemStack stack = blockEntity.itemHandler.getStackInSlot(0);
            int fluidFillingSum = 0;
            int fluidFillingLeftSum = 0;
            if (((FluidTank)blockEntity.fluidStorage).getFluidAmount() - blockEntity.fluidFillingSumPending <= 0) {
                return;
            }
            int energyConsumptionPerTick = Math.max(1, (int)Math.ceil((double)ENERGY_USAGE_PER_TICK * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
            if (((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() < energyConsumptionPerTick) {
                return;
            }
            IFluidHandlerItem fluidStorage = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidStorage == null) {
                return;
            }
            for (int i = 0; i < fluidStorage.getTanks(); ++i) {
                FluidStack fluidStack = fluidStorage.getFluidInTank(i);
                if (fluidStorage.getTankCapacity(i) <= fluidStack.getAmount() || !((FluidTank)blockEntity.fluidStorage).isEmpty() && (!fluidStack.isEmpty() || !fluidStorage.isFluidValid(i, ((FluidTank)blockEntity.fluidStorage).getFluid())) && !FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)((FluidTank)blockEntity.fluidStorage).getFluid())) continue;
                fluidFillingSum += Math.min(((FluidTank)blockEntity.fluidStorage).getFluidAmount() - blockEntity.fluidFillingSumPending - fluidFillingSum, Math.min(fluidStorage.getTankCapacity(i) - fluidStack.getAmount(), MAX_FLUID_FILLING_PER_TICK - fluidFillingSum));
                fluidFillingLeftSum += fluidStorage.getTankCapacity(i) - fluidStack.getAmount();
            }
            if (fluidFillingSum == 0) {
                return;
            }
            blockEntity.fluidFillingLeft = fluidFillingLeftSum;
            blockEntity.fluidFillingSumPending += fluidFillingSum;
            ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick);
            int fluidSumFillable = Math.min(((FluidTank)blockEntity.fluidStorage).getFluidAmount(), blockEntity.fluidFillingSumPending);
            FluidStack fluidStackToFill = blockEntity.getFluid(0);
            int fluidSumFilled = fluidStorage.fill(new FluidStack(fluidStackToFill.getFluidHolder(), fluidSumFillable, fluidStackToFill.getComponentsPatch()), IFluidHandler.FluidAction.EXECUTE);
            if (fluidSumFilled <= 0) {
                FluidFillerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                return;
            }
            blockEntity.itemHandler.setStackInSlot(0, fluidStorage.getContainer());
            ((FluidTank)blockEntity.fluidStorage).drain(fluidSumFilled, IFluidHandler.FluidAction.EXECUTE);
            blockEntity.fluidFillingSumPending -= fluidSumFilled;
            blockEntity.fluidFillingLeft = fluidFillingLeftSum - fluidSumFilled;
            if (blockEntity.fluidFillingLeft <= 0) {
                blockEntity.resetProgress();
            }
            FluidFillerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        } else {
            blockEntity.resetProgress();
            FluidFillerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.fluidFillingLeft = -1;
        this.fluidFillingSumPending = 0;
    }

    private boolean hasRecipe() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.getCapability(Capabilities.FluidHandler.ITEM) != null) {
            IFluidHandlerItem fluidStorage = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidStorage == null) {
                return false;
            }
            for (int i = 0; i < fluidStorage.getTanks(); ++i) {
                FluidStack fluidStack = fluidStorage.getFluidInTank(i);
                if (fluidStorage.getTankCapacity(i) <= fluidStack.getAmount() || !((FluidTank)this.fluidStorage).isEmpty() && (!fluidStack.isEmpty() || !fluidStorage.isFluidValid(i, ((FluidTank)this.fluidStorage).getFluid())) && !FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)((FluidTank)this.fluidStorage).getFluid())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }
}

