/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.EnergizerRecipe;
import me.jddev0.ep.screen.EnergizerMenu;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergizerBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler> {
    public static final float ENERGY_CONSUMPTION_MULTIPLIER = ModConfigs.COMMON_ENERGIZER_ENERGY_CONSUMPTION_MULTIPLIER.getValue().floatValue();
    private final IItemHandler itemHandlerSided;
    private int progress;
    private int maxProgress;
    private int energyConsumptionLeft;
    private boolean hasEnoughEnergy;
    private int timeoutOffState;

    public EnergizerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.ENERGIZER_ENTITY.get(), blockPos, blockState, "energizer", ModConfigs.COMMON_ENERGIZER_CAPACITY.getValue(), ModConfigs.COMMON_ENERGIZER_TRANSFER_RATE.getValue(), 2, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1);
        this.maxProgress = ModConfigs.COMMON_ENERGIZER_RECIPE_DURATION.getValue();
        this.energyConsumptionLeft = -1;
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * EnergizerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * EnergizerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                EnergizerBlockEntity.this.setChanged();
                EnergizerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                EnergizerBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (EnergizerBlockEntity.this.level == null || RecipeUtils.isIngredientOfAny(EnergizerBlockEntity.this.level, EnergizerRecipe.Type.INSTANCE, stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(EnergizerBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack))) {
                        EnergizerBlockEntity.this.resetProgress(EnergizerBlockEntity.this.worldPosition, EnergizerBlockEntity.this.level.getBlockState(EnergizerBlockEntity.this.worldPosition));
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> EnergizerBlockEntity.hasRecipe(this) ? this.getEnergyConsumptionPerTick() : -1, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new EnergizerMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put("recipe.progress", (Tag)IntTag.valueOf((int)this.progress));
        nbt.put("recipe.energy_consumption_left", (Tag)IntTag.valueOf((int)this.energyConsumptionLeft));
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.progress = nbt.getInt("recipe.progress");
        this.energyConsumptionLeft = nbt.getInt("recipe.energy_consumption_left");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, EnergizerBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (blockEntity.timeoutOffState > 0) {
            --blockEntity.timeoutOffState;
            if (blockEntity.timeoutOffState == 0 && level.getBlockState(blockPos).hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)level.getBlockState(blockPos).getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
                level.setBlock(blockPos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.getValue((Property)BlockStateProperties.POWERED))) {
            return;
        }
        if (EnergizerBlockEntity.hasRecipe(blockEntity)) {
            int energyConsumptionPerTick;
            SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
            for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
                inventory.setItem(i, blockEntity.itemHandler.getStackInSlot(i));
            }
            Optional recipe = level.getRecipeManager().getRecipeFor((RecipeType)EnergizerRecipe.Type.INSTANCE, (RecipeInput)new ContainerRecipeInputWrapper((Container)inventory), level);
            if (recipe.isEmpty()) {
                return;
            }
            int energyConsumption = ((EnergizerRecipe)((RecipeHolder)recipe.get()).value()).getEnergyConsumption();
            energyConsumption = (int)((float)energyConsumption * ENERGY_CONSUMPTION_MULTIPLIER);
            if (blockEntity.progress == 0) {
                blockEntity.energyConsumptionLeft = energyConsumption;
            }
            if ((energyConsumptionPerTick = blockEntity.getEnergyConsumptionPerTick()) <= ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()) {
                blockEntity.hasEnoughEnergy = true;
                blockEntity.timeoutOffState = 0;
                if (level.getBlockState(blockPos).hasProperty((Property)BlockStateProperties.LIT) && !((Boolean)level.getBlockState(blockPos).getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
                    level.setBlock(blockPos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 3);
                }
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0 || energyConsumptionPerTick < 0) {
                    blockEntity.resetProgress(blockPos, state);
                    EnergizerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
                ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick);
                blockEntity.energyConsumptionLeft -= energyConsumptionPerTick;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    EnergizerBlockEntity.craftItem(blockPos, state, blockEntity);
                }
                EnergizerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                if (blockEntity.timeoutOffState == 0) {
                    blockEntity.timeoutOffState = ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
                }
                EnergizerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            if (blockEntity.timeoutOffState == 0) {
                blockEntity.timeoutOffState = ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
            }
            EnergizerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    protected final int getEnergyConsumptionPerTick() {
        if (this.level == null) {
            return -1;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)EnergizerRecipe.Type.INSTANCE, (RecipeInput)new ContainerRecipeInputWrapper((Container)inventory), this.level);
        if (recipe.isEmpty()) {
            return -1;
        }
        int energyConsumption = ((EnergizerRecipe)((RecipeHolder)recipe.get()).value()).getEnergyConsumption();
        energyConsumption = (int)((float)energyConsumption * ENERGY_CONSUMPTION_MULTIPLIER);
        int energyConsumptionPerTick = (int)Math.ceil((float)energyConsumption / (float)this.maxProgress);
        if (this.progress == this.maxProgress - 1) {
            energyConsumptionPerTick = this.energyConsumptionLeft;
        }
        return energyConsumptionPerTick;
    }

    private void resetProgress(BlockPos blockPos, BlockState state) {
        this.progress = 0;
        this.energyConsumptionLeft = -1;
        this.hasEnoughEnergy = false;
    }

    private static void craftItem(BlockPos blockPos, BlockState state, EnergizerBlockEntity blockEntity) {
        Level level = blockEntity.level;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = level.getRecipeManager().getRecipeFor((RecipeType)EnergizerRecipe.Type.INSTANCE, (RecipeInput)new ContainerRecipeInputWrapper((Container)inventory), level);
        if (!EnergizerBlockEntity.hasRecipe(blockEntity) || recipe.isEmpty()) {
            return;
        }
        blockEntity.itemHandler.extractItem(0, 1, false);
        blockEntity.itemHandler.setStackInSlot(1, ((EnergizerRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copyWithCount(blockEntity.itemHandler.getStackInSlot(1).getCount() + ((EnergizerRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getCount()));
        blockEntity.resetProgress(blockPos, state);
    }

    private static boolean hasRecipe(EnergizerBlockEntity blockEntity) {
        Level level = blockEntity.level;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = level.getRecipeManager().getRecipeFor((RecipeType)EnergizerRecipe.Type.INSTANCE, (RecipeInput)new ContainerRecipeInputWrapper((Container)inventory), level);
        return recipe.isPresent() && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 1, ((EnergizerRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)level.registryAccess()));
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress(this.getBlockPos(), this.getBlockState());
        super.updateUpgradeModules();
    }
}

