/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import me.jddev0.ep.block.AssemblingMachineBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.MenuInventoryStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.recipe.AlloyFurnaceRecipe;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.IngredientWithCount;
import me.jddev0.ep.screen.AlloyFurnaceMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlloyFurnaceBlockEntity
extends MenuInventoryStorageBlockEntity<ItemStackHandler> {
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_ALLOY_FURNACE_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    private int progress;
    private int maxProgress;
    private int litDuration;
    private int maxLitDuration;
    private final Predicate<Integer> canOutput = i -> {
        if (i == 3) {
            ItemStack item = this.itemHandler.getStackInSlot(i.intValue());
            return item.getBurnTime(null) <= 0;
        }
        return i > 3 && i < 6;
    };
    private final IItemHandler itemHandlerSidedTopBottom = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 3, this.canOutput);
    private final IItemHandler itemHandlerSidedFront = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i >= 0 && i < 3, this.canOutput);
    private final IItemHandler itemHandlerSidedBack = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 1, this.canOutput);
    private final IItemHandler itemHandlerSidedLeft = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, this.canOutput);
    private final IItemHandler itemHandlerSidedRight = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 2, this.canOutput);

    public AlloyFurnaceBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.ALLOY_FURNACE_ENTITY.get(), blockPos, blockState, "alloy_furnace", 6);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                AlloyFurnaceBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0, 1, 2 -> {
                        if (AlloyFurnaceBlockEntity.this.level == null || AlloyFurnaceBlockEntity.this.level.getRecipeManager().getAllRecipesFor((RecipeType)AlloyFurnaceRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).map(AlloyFurnaceRecipe::getInputs).anyMatch(inputs -> Arrays.stream(inputs).map(IngredientWithCount::input).anyMatch(ingredient -> ingredient.test(stack)))) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3 -> {
                        if (stack.getBurnTime(null) > 0) {
                            yield true;
                        }
                        yield false;
                    }
                    case 4, 5 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < 3) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(AlloyFurnaceBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack))) {
                        AlloyFurnaceBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new ProgressValueContainerData(() -> this.litDuration, value -> {
            this.litDuration = value;
        }), new ProgressValueContainerData(() -> this.maxLitDuration, value -> {
            this.maxLitDuration = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new AlloyFurnaceMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)AssemblingMachineBlock.FACING);
        if (facing == side) {
            return this.itemHandlerSidedFront;
        }
        if (facing.getOpposite() == side) {
            return this.itemHandlerSidedBack;
        }
        if (facing.getClockWise() == side) {
            return this.itemHandlerSidedLeft;
        }
        if (facing.getCounterClockWise() == side) {
            return this.itemHandlerSidedRight;
        }
        return this.itemHandlerSidedTopBottom;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put("recipe.progress", (Tag)IntTag.valueOf((int)this.progress));
        nbt.put("recipe.max_progress", (Tag)IntTag.valueOf((int)this.maxProgress));
        nbt.put("recipe.lit_duration", (Tag)IntTag.valueOf((int)this.litDuration));
        nbt.put("recipe.max_lit_duration", (Tag)IntTag.valueOf((int)this.maxLitDuration));
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.progress = nbt.getInt("recipe.progress");
        this.maxProgress = nbt.getInt("recipe.max_progress");
        this.litDuration = nbt.getInt("recipe.lit_duration");
        this.maxLitDuration = nbt.getInt("recipe.max_lit_duration");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AlloyFurnaceBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        boolean hasNotEnoughFuel = false;
        if (blockEntity.litDuration > 0) {
            --blockEntity.litDuration;
            if (blockEntity.litDuration <= 0) {
                blockEntity.maxLitDuration = 0;
                hasNotEnoughFuel = true;
            }
            AlloyFurnaceBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
        if (blockEntity.hasRecipe()) {
            Optional<RecipeHolder<AlloyFurnaceRecipe>> recipe = blockEntity.getCurrentRecipe();
            if (recipe.isEmpty()) {
                return;
            }
            if (blockEntity.litDuration <= 0) {
                ItemStack item = blockEntity.itemHandler.getStackInSlot(3);
                blockEntity.litDuration = blockEntity.maxLitDuration = item.getBurnTime(null);
                if (blockEntity.maxLitDuration > 0) {
                    blockEntity.onHasEnoughFuel();
                    hasNotEnoughFuel = false;
                    if (item.hasCraftingRemainingItem()) {
                        blockEntity.itemHandler.setStackInSlot(3, item.getCraftingRemainingItem());
                    } else {
                        blockEntity.itemHandler.extractItem(3, 1, false);
                    }
                }
            }
            if (blockEntity.maxProgress == 0) {
                blockEntity.maxProgress = Math.max(1, (int)((float)((AlloyFurnaceRecipe)recipe.get().value()).getTicks() * RECIPE_DURATION_MULTIPLIER));
            }
            if (blockEntity.litDuration > 0) {
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0) {
                    if (hasNotEnoughFuel) {
                        blockEntity.onHasNotEnoughFuel();
                    }
                    blockEntity.resetProgress();
                    AlloyFurnaceBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.craftItem(recipe.get());
                }
                AlloyFurnaceBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
            } else {
                blockEntity.progress = Math.max(blockEntity.progress - 2, 0);
                hasNotEnoughFuel = true;
                AlloyFurnaceBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        } else {
            blockEntity.resetProgress();
            AlloyFurnaceBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
        if (hasNotEnoughFuel) {
            blockEntity.onHasNotEnoughFuel();
        }
    }

    private void onHasEnoughFuel() {
        if (this.level.getBlockState(this.getBlockPos()).hasProperty((Property)BlockStateProperties.LIT) && !((Boolean)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private void onHasNotEnoughFuel() {
        if (this.level.getBlockState(this.getBlockPos()).hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)this.level.getBlockState(this.getBlockPos()).getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private RecipeInput getRecipeInput(Container inventory) {
        return new ContainerRecipeInputWrapper(inventory);
    }

    private Optional<RecipeHolder<AlloyFurnaceRecipe>> getRecipeFor(Container inventory) {
        return this.level.getRecipeManager().getRecipeFor(EPRecipes.ALLOY_FURNACE_TYPE.get(), this.getRecipeInput(inventory), this.level);
    }

    private Optional<RecipeHolder<AlloyFurnaceRecipe>> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        return this.getRecipeFor((Container)inventory);
    }

    private boolean hasRecipe() {
        if (this.level == null) {
            return false;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Optional<RecipeHolder<AlloyFurnaceRecipe>> recipe = this.getRecipeFor((Container)inventory);
        return recipe.isPresent() && this.canCraftRecipe(inventory, recipe.get());
    }

    protected void craftItem(RecipeHolder<AlloyFurnaceRecipe> recipe) {
        if (this.level == null || !this.hasRecipe()) {
            return;
        }
        IngredientWithCount[] inputs = ((AlloyFurnaceRecipe)recipe.value()).getInputs();
        boolean[] usedIndices = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            usedIndices[i] = this.itemHandler.getStackInSlot(i).isEmpty();
        }
        int len = Math.min(inputs.length, 3);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 3; ++j) {
                if (usedIndices[j]) continue;
                ItemStack item = this.itemHandler.getStackInSlot(j);
                if (indexMinCount != -1 && item.getCount() >= minCount || !input.input().test(item) || item.getCount() < input.count()) continue;
                indexMinCount = j;
                minCount = item.getCount();
            }
            if (indexMinCount == -1) {
                return;
            }
            usedIndices[indexMinCount] = true;
            this.itemHandler.extractItem(indexMinCount, input.count(), false);
        }
        ItemStack[] outputs = ((AlloyFurnaceRecipe)recipe.value()).generateOutputs(this.level.random);
        this.itemHandler.setStackInSlot(4, outputs[0].copyWithCount(this.itemHandler.getStackInSlot(4).getCount() + outputs[0].getCount()));
        if (!outputs[1].isEmpty()) {
            this.itemHandler.setStackInSlot(5, outputs[1].copyWithCount(this.itemHandler.getStackInSlot(5).getCount() + outputs[1].getCount()));
        }
        this.resetProgress();
    }

    private boolean canCraftRecipe(SimpleContainer inventory, RecipeHolder<AlloyFurnaceRecipe> recipe) {
        ItemStack[] maxOutputs = ((AlloyFurnaceRecipe)recipe.value()).getMaxOutputCounts();
        return this.level != null && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 4, maxOutputs[0]) && (maxOutputs[1].isEmpty() || InventoryUtils.canInsertItemIntoSlot((Container)inventory, 5, maxOutputs[1]));
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 0;
    }
}

