/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncFurnaceRecipeTypeS2CPacket;
import me.jddev0.ep.recipe.FurnaceRecipeTypePacketUpdate;
import me.jddev0.ep.screen.AdvancedPoweredFurnaceMenu;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedPoweredFurnaceBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler>
implements FurnaceRecipeTypePacketUpdate {
    private static final List<@NotNull ResourceLocation> RECIPE_BLACKLIST = ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_RECIPE_BLACKLIST.getValue();
    private static final int ENERGY_USAGE_PER_INPUT_PER_TICK = ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_ENERGY_CONSUMPTION_PER_INPUT_PER_TICK.getValue();
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    private final IItemHandler itemHandlerSided;
    private int[] progress;
    private int[] maxProgress;
    private int[] energyConsumptionLeft;
    private boolean[] hasEnoughEnergy;
    @NotNull
    private RecipeType<? extends AbstractCookingRecipe> recipeType;
    private int timeoutOffState;

    public AdvancedPoweredFurnaceBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.ADVANCED_POWERED_FURNACE_ENTITY.get(), blockPos, blockState, "advanced_powered_furnace", ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_CAPACITY.getValue(), ModConfigs.COMMON_ADVANCED_POWERED_FURNACE_TRANSFER_RATE.getValue(), 6, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.FURNACE_MODE);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i >= 0 && i < 3, i -> i >= 3 && i < 6);
        this.progress = new int[]{0, 0, 0};
        this.maxProgress = new int[]{0, 0, 0};
        this.energyConsumptionLeft = new int[]{-1, -1, -1};
        this.hasEnoughEnergy = new boolean[]{false, false, false};
        this.recipeType = RecipeType.SMELTING;
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * AdvancedPoweredFurnaceBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * AdvancedPoweredFurnaceBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                AdvancedPoweredFurnaceBlockEntity.this.setChanged();
                AdvancedPoweredFurnaceBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                AdvancedPoweredFurnaceBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0, 1, 2 -> {
                        if (AdvancedPoweredFurnaceBlockEntity.this.level == null || RecipeUtils.isIngredientOfAny(AdvancedPoweredFurnaceBlockEntity.this.level, AdvancedPoweredFurnaceBlockEntity.this.getRecipeForFurnaceModeUpgrade(), stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3, 4, 5 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < 3) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(AdvancedPoweredFurnaceBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack))) {
                        AdvancedPoweredFurnaceBlockEntity.this.resetProgress(slot, AdvancedPoweredFurnaceBlockEntity.this.worldPosition, AdvancedPoweredFurnaceBlockEntity.this.level.getBlockState(AdvancedPoweredFurnaceBlockEntity.this.worldPosition));
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress[0], value -> {
            this.progress[0] = value;
        }), new ProgressValueContainerData(() -> this.progress[1], value -> {
            this.progress[1] = value;
        }), new ProgressValueContainerData(() -> this.progress[2], value -> {
            this.progress[2] = value;
        }), new ProgressValueContainerData(() -> this.maxProgress[0], value -> {
            this.maxProgress[0] = value;
        }), new ProgressValueContainerData(() -> this.maxProgress[1], value -> {
            this.maxProgress[1] = value;
        }), new ProgressValueContainerData(() -> this.maxProgress[2], value -> {
            this.maxProgress[2] = value;
        }), new EnergyValueContainerData(this::getEnergyConsumptionPerTickSum, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[0], value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[1], value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[2], value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy[0], value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy[1], value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy[2], value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        ModMessages.sendToPlayer(new SyncFurnaceRecipeTypeS2CPacket(this.getRecipeForFurnaceModeUpgrade(), this.getBlockPos()), (ServerPlayer)player);
        return new AdvancedPoweredFurnaceMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        int i;
        super.saveAdditional(nbt, registries);
        for (i = 0; i < 3; ++i) {
            nbt.put("recipe.progress." + i, (Tag)IntTag.valueOf((int)this.progress[i]));
        }
        for (i = 0; i < 3; ++i) {
            nbt.put("recipe.max_progress." + i, (Tag)IntTag.valueOf((int)this.maxProgress[i]));
        }
        for (i = 0; i < 3; ++i) {
            nbt.put("recipe.energy_consumption_left." + i, (Tag)IntTag.valueOf((int)this.energyConsumptionLeft[i]));
        }
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        int i;
        super.loadAdditional(nbt, registries);
        for (i = 0; i < 3; ++i) {
            this.progress[i] = nbt.getInt("recipe.progress." + i);
        }
        for (i = 0; i < 3; ++i) {
            this.maxProgress[i] = nbt.getInt("recipe.max_progress." + i);
        }
        for (i = 0; i < 3; ++i) {
            this.energyConsumptionLeft[i] = nbt.getInt("recipe.energy_consumption_left." + i);
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AdvancedPoweredFurnaceBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (blockEntity.timeoutOffState > 0) {
            --blockEntity.timeoutOffState;
            if (blockEntity.timeoutOffState == 0 && level.getBlockState(blockPos).hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)level.getBlockState(blockPos).getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
                level.setBlock(blockPos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.getValue((Property)BlockStateProperties.POWERED))) {
            return;
        }
        boolean hasNoRecipe = true;
        int hasNotEnoughEnergyCount = 0;
        for (int i = 0; i < 3; ++i) {
            if (AdvancedPoweredFurnaceBlockEntity.hasRecipe(i, blockEntity)) {
                hasNoRecipe = false;
                SimpleContainer inventory = new SimpleContainer(2);
                inventory.setItem(0, blockEntity.itemHandler.getStackInSlot(i));
                inventory.setItem(1, blockEntity.itemHandler.getStackInSlot(3 + i));
                Optional<? extends RecipeHolder<? extends AbstractCookingRecipe>> recipe = blockEntity.getRecipeFor((Container)inventory, level);
                if (recipe.isEmpty()) continue;
                int cookingTime = ((AbstractCookingRecipe)recipe.get().value()).getCookingTime();
                if (blockEntity.maxProgress[i] == 0) {
                    blockEntity.maxProgress[i] = Math.max(1, (int)Math.ceil((double)((float)cookingTime * RECIPE_DURATION_MULTIPLIER / 6.0f) / blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.SPEED)));
                }
                int energyUsagePerInputPerTick = Math.max(1, (int)Math.ceil((double)ENERGY_USAGE_PER_INPUT_PER_TICK * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
                if (blockEntity.energyConsumptionLeft[i] < 0) {
                    blockEntity.energyConsumptionLeft[i] = energyUsagePerInputPerTick * blockEntity.maxProgress[i];
                }
                if (energyUsagePerInputPerTick <= ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()) {
                    blockEntity.hasEnoughEnergy[i] = true;
                    blockEntity.timeoutOffState = 0;
                    if (level.getBlockState(blockPos).hasProperty((Property)BlockStateProperties.LIT) && !((Boolean)level.getBlockState(blockPos).getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
                        level.setBlock(blockPos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 3);
                    }
                    if (blockEntity.progress[i] < 0 || blockEntity.maxProgress[i] < 0 || blockEntity.energyConsumptionLeft[i] < 0) {
                        blockEntity.resetProgress(i, blockPos, state);
                        AdvancedPoweredFurnaceBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                        continue;
                    }
                    ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyUsagePerInputPerTick);
                    int n = i;
                    blockEntity.energyConsumptionLeft[n] = blockEntity.energyConsumptionLeft[n] - energyUsagePerInputPerTick;
                    int n2 = i;
                    blockEntity.progress[n2] = blockEntity.progress[n2] + 1;
                    if (blockEntity.progress[i] >= blockEntity.maxProgress[i]) {
                        AdvancedPoweredFurnaceBlockEntity.craftItem(i, blockPos, state, blockEntity);
                    }
                    AdvancedPoweredFurnaceBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                    continue;
                }
                blockEntity.hasEnoughEnergy[i] = false;
                ++hasNotEnoughEnergyCount;
                AdvancedPoweredFurnaceBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                continue;
            }
            blockEntity.resetProgress(i, blockPos, state);
            ++hasNotEnoughEnergyCount;
            AdvancedPoweredFurnaceBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
        if ((hasNoRecipe || hasNotEnoughEnergyCount == 3) && blockEntity.timeoutOffState == 0) {
            blockEntity.timeoutOffState = ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
        }
    }

    protected final int getEnergyConsumptionPerTickSum() {
        int energyConsumptionSum = -1;
        for (int i = 0; i < 3; ++i) {
            if (!AdvancedPoweredFurnaceBlockEntity.hasRecipe(i, this)) continue;
            SimpleContainer inventory = new SimpleContainer(2);
            inventory.setItem(0, this.itemHandler.getStackInSlot(i));
            inventory.setItem(1, this.itemHandler.getStackInSlot(3 + i));
            Optional<? extends RecipeHolder<? extends AbstractCookingRecipe>> recipe = this.getRecipeFor((Container)inventory, this.level);
            if (recipe.isEmpty()) continue;
            int energyConsumption = Math.max(1, (int)Math.ceil((double)ENERGY_USAGE_PER_INPUT_PER_TICK * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
            energyConsumptionSum = energyConsumptionSum == -1 ? energyConsumption : (energyConsumptionSum += energyConsumption);
            if (energyConsumptionSum >= 0) continue;
            energyConsumptionSum = Integer.MAX_VALUE;
        }
        return energyConsumptionSum;
    }

    private void resetProgress(int index, BlockPos blockPos, BlockState state) {
        this.progress[index] = 0;
        this.maxProgress[index] = 0;
        this.energyConsumptionLeft[index] = -1;
        this.hasEnoughEnergy[index] = false;
    }

    private static void craftItem(int index, BlockPos blockPos, BlockState state, AdvancedPoweredFurnaceBlockEntity blockEntity) {
        Level level = blockEntity.level;
        SimpleContainer inventory = new SimpleContainer(2);
        inventory.setItem(0, blockEntity.itemHandler.getStackInSlot(index));
        inventory.setItem(1, blockEntity.itemHandler.getStackInSlot(3 + index));
        Optional<? extends RecipeHolder<? extends AbstractCookingRecipe>> recipe = blockEntity.getRecipeFor((Container)inventory, level);
        if (!AdvancedPoweredFurnaceBlockEntity.hasRecipe(index, blockEntity) || recipe.isEmpty()) {
            return;
        }
        blockEntity.itemHandler.extractItem(index, 1, false);
        blockEntity.itemHandler.setStackInSlot(3 + index, ((AbstractCookingRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copyWithCount(blockEntity.itemHandler.getStackInSlot(3 + index).getCount() + ((AbstractCookingRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getCount()));
        blockEntity.resetProgress(index, blockPos, state);
    }

    private static boolean hasRecipe(int index, AdvancedPoweredFurnaceBlockEntity blockEntity) {
        Level level = blockEntity.level;
        SimpleContainer inventory = new SimpleContainer(2);
        inventory.setItem(0, blockEntity.itemHandler.getStackInSlot(index));
        inventory.setItem(1, blockEntity.itemHandler.getStackInSlot(3 + index));
        Optional<? extends RecipeHolder<? extends AbstractCookingRecipe>> recipe = blockEntity.getRecipeFor((Container)inventory, level);
        inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        return recipe.isPresent() && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 3 + index, ((AbstractCookingRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)level.registryAccess()));
    }

    private Optional<? extends RecipeHolder<? extends AbstractCookingRecipe>> getRecipeFor(Container container, Level level) {
        return level.getRecipeManager().getAllRecipesFor(this.getRecipeForFurnaceModeUpgrade()).stream().filter(recipe -> !RECIPE_BLACKLIST.contains(recipe.id())).filter(recipe -> ((AbstractCookingRecipe)recipe.value()).matches(new SingleRecipeInput(container.getItem(0)), level)).findFirst();
    }

    public RecipeType<? extends AbstractCookingRecipe> getRecipeForFurnaceModeUpgrade() {
        if (this.level != null && this.level.isClientSide()) {
            return this.recipeType;
        }
        double value = this.upgradeModuleInventory.getUpgradeModuleModifierEffect(3, UpgradeModuleModifier.FURNACE_MODE);
        if (value == 1.0) {
            return RecipeType.BLASTING;
        }
        if (value == 2.0) {
            return RecipeType.SMOKING;
        }
        return RecipeType.SMELTING;
    }

    @Override
    public void setRecipeType(RecipeType<? extends AbstractCookingRecipe> recipeType) {
        this.recipeType = recipeType;
    }

    @Override
    protected void updateUpgradeModules() {
        for (int i = 0; i < 3; ++i) {
            this.resetProgress(i, this.getBlockPos(), this.getBlockState());
        }
        super.updateUpgradeModules();
        if (this.level != null && !this.level.isClientSide()) {
            ModMessages.sendToPlayersWithinXBlocks(new SyncFurnaceRecipeTypeS2CPacket(this.getRecipeForFurnaceModeUpgrade(), this.getBlockPos()), this.getBlockPos(), (ServerLevel)this.level, 32);
        }
    }
}

