/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.behavior;

import me.jddev0.ep.item.EPItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class ModBlockBehaviors {
    private ModBlockBehaviors() {
    }

    public static void register() {
        DispenserBlock.registerBehavior((ItemLike)Items.SHEARS, (DispenseItemBehavior)new ShearsDispenseItemBehavior(){

            protected ItemStack execute(BlockSource blockSource, ItemStack itemStack) {
                ServerLevel level = blockSource.level();
                if (!level.isClientSide() && level instanceof ServerLevel) {
                    ServerLevel serverLevel = level;
                    BlockPos blockPos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                    if (1.tryCraftCableInsulator((Level)level, blockPos)) {
                        itemStack.hurtAndBreak(1, serverLevel, null, item -> itemStack.setCount(0));
                        this.setSuccess(true);
                        return itemStack;
                    }
                }
                return super.execute(blockSource, itemStack);
            }

            private static boolean tryCraftCableInsulator(Level level, BlockPos blockPos) {
                BlockState blockstate = level.getBlockState(blockPos);
                if (blockstate.is(BlockTags.WOOL)) {
                    level.destroyBlock(blockPos, false, null);
                    ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, new ItemStack((ItemLike)EPItems.CABLE_INSULATOR.get(), 18), 0.0, 0.0, 0.0);
                    itemEntity.setPickUpDelay(20);
                    level.addFreshEntity((Entity)itemEntity);
                    level.playSound(null, blockPos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
                return false;
            }
        });
    }
}

