/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.ToIntFunction;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.LightningGeneratorBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class LightningGeneratorBlock
extends BaseEntityBlock {
    public static final MapCodec<LightningGeneratorBlock> CODEC = LightningGeneratorBlock.simpleCodec(LightningGeneratorBlock::new);
    public static final int ENERGY_PER_LIGHTNING_STRIKE = ModConfigs.COMMON_LIGHTNING_GENERATOR_CAPACITY.getValue();
    public static final BooleanProperty HIT_BY_LIGHTNING_BOLT = BooleanProperty.create((String)"hit_by_lightning_bolt");
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = state -> (Boolean)state.getValue((Property)HIT_BY_LIGHTNING_BOLT) != false ? 15 : 0;
    private static final int ACTIVATION_TICKS = 8;

    public LightningGeneratorBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HIT_BY_LIGHTNING_BOLT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new LightningGeneratorBlockEntity(blockPos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{HIT_BY_LIGHTNING_BOLT});
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos blockPos, Player player, BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof LightningGeneratorBlockEntity)) {
            throw new IllegalStateException("Container is invalid");
        }
        player.openMenu((MenuProvider)((LightningGeneratorBlockEntity)blockEntity), blockPos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void neighborChanged(BlockState selfState, Level level, BlockPos selfPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(selfState, level, selfPos, fromBlock, fromPos, isMoving);
        if (level.isClientSide()) {
            return;
        }
        if (!selfPos.above().equals((Object)fromPos) || !(fromBlock instanceof LightningRodBlock)) {
            return;
        }
        BlockState fromState = level.getBlockState(fromPos);
        if (!(fromState.hasProperty((Property)LightningRodBlock.POWERED) && ((Boolean)fromState.getValue((Property)LightningRodBlock.POWERED)).booleanValue() && fromState.hasProperty((Property)LightningRodBlock.POWERED) && fromState.getValue((Property)DirectionalBlock.FACING) == Direction.UP)) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(selfPos);
        if (!(blockEntity instanceof LightningGeneratorBlockEntity)) {
            return;
        }
        level.setBlock(selfPos, (BlockState)selfState.setValue((Property)HIT_BY_LIGHTNING_BOLT, (Comparable)Boolean.TRUE), 3);
        level.scheduleTick(selfPos, (Block)this, 8);
        ((LightningGeneratorBlockEntity)blockEntity).onLightningStrike();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return LightningGeneratorBlock.createTickerHelper(type, EPBlockEntities.LIGHTING_GENERATOR_ENTITY.get(), LightningGeneratorBlockEntity::tick);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        level.setBlock(blockPos, (BlockState)state.setValue((Property)HIT_BY_LIGHTNING_BOLT, (Comparable)Boolean.valueOf(false)), 3);
    }

    public void animateTick(BlockState state, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)state.getValue((Property)HIT_BY_LIGHTNING_BOLT)).booleanValue()) {
            ParticleUtils.spawnParticlesOnBlockFaces((Level)level, (BlockPos)blockPos, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, (IntProvider)UniformInt.of((int)2, (int)5));
        }
    }

    public static class Item
    extends BlockItem {
        public Item(Block block, Item.Properties props) {
            super(block, props);
        }

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
            if (Screen.hasShiftDown()) {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.lightning_generator.txt.shift.1", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(ENERGY_PER_LIGHTNING_STRIKE)}).withStyle(ChatFormatting.GRAY));
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.lightning_generator.txt.shift.2").withStyle(ChatFormatting.GRAY));
            } else {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
            }
        }
    }
}

