/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.jddev0.ep.block.entity.ItemSiloBlockEntity;
import me.jddev0.ep.machine.tier.ItemSiloTier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ItemSiloBlock
extends BaseEntityBlock {
    public static final MapCodec<ItemSiloBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.xmap(ItemSiloTier::valueOf, Enum::toString).fieldOf("tier").forGetter(ItemSiloBlock::getTier), (App)BlockBehaviour.Properties.CODEC.fieldOf("properties").forGetter(BlockBehaviour::properties)).apply((Applicative)instance, ItemSiloBlock::new));
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private final ItemSiloTier tier;

    public ItemSiloBlock(ItemSiloTier tier, BlockBehaviour.Properties properties) {
        super(properties);
        this.tier = tier;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public ItemSiloTier getTier() {
        return this.tier;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new ItemSiloBlockEntity(blockPos, state, this.tier);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof ItemSiloBlockEntity)) {
            return super.getAnalogOutputSignal(state, level, blockPos);
        }
        ItemSiloBlockEntity itemSiloBlockEntity = (ItemSiloBlockEntity)blockEntity;
        return itemSiloBlockEntity.getRedstoneOutput();
    }

    public void onRemove(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (state.getBlock() == newState.getBlock()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof ItemSiloBlockEntity)) {
            return;
        }
        ((ItemSiloBlockEntity)blockEntity).drops(level, blockPos);
        super.onRemove(state, level, blockPos, newState, isMoving);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos blockPos, Player player, BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof ItemSiloBlockEntity) || ((ItemSiloBlockEntity)blockEntity).getTier() != this.tier) {
            throw new IllegalStateException("Container is invalid");
        }
        player.openMenu((MenuProvider)((ItemSiloBlockEntity)blockEntity), blockPos);
        return InteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{FACING});
    }

    public static class Item
    extends BlockItem {
        private final ItemSiloTier tier;

        public Item(Block block, Item.Properties props, ItemSiloTier tier) {
            super(block, props);
            this.tier = tier;
        }

        public ItemSiloTier getTier() {
            return this.tier;
        }

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
            if (Screen.hasShiftDown()) {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.item_silo_capacity.txt", (Object[])new Object[]{this.tier.getItemSiloCapacity()}).withStyle(ChatFormatting.GRAY));
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.item_silo.txt.shift").withStyle(ChatFormatting.GRAY));
            } else {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
            }
        }
    }
}

