/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.entity.ItemConveyorBeltSorterBlockEntity;
import me.jddev0.ep.machine.tier.ConveyorBeltTier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ItemConveyorBeltSorterBlock
extends BaseEntityBlock {
    public static final MapCodec<ItemConveyorBeltSorterBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.xmap(ConveyorBeltTier::valueOf, Enum::toString).fieldOf("tier").forGetter(ItemConveyorBeltSorterBlock::getTier), (App)BlockBehaviour.Properties.CODEC.fieldOf("properties").forGetter(BlockBehaviour::properties)).apply((Applicative)instance, ItemConveyorBeltSorterBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private final ConveyorBeltTier tier;

    protected ItemConveyorBeltSorterBlock(ConveyorBeltTier tier, BlockBehaviour.Properties props) {
        super(props);
        this.tier = tier;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public ConveyorBeltTier getTier() {
        return this.tier;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new ItemConveyorBeltSorterBlockEntity(blockPos, state, this.tier);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter getter, BlockPos blockPos, Direction direction) {
        return (Boolean)state.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos blockPos, Player player, BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof ItemConveyorBeltSorterBlockEntity)) {
            throw new IllegalStateException("Container is invalid");
        }
        player.openMenu((MenuProvider)((ItemConveyorBeltSorterBlockEntity)blockEntity), blockPos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void neighborChanged(BlockState selfState, Level level, BlockPos selfPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        int dz;
        int dy;
        super.neighborChanged(selfState, level, selfPos, fromBlock, fromPos, isMoving);
        if (level.isClientSide()) {
            return;
        }
        int dx = fromPos.getX() - selfPos.getX();
        Direction dir = Direction.fromDelta((int)dx, (int)(dy = fromPos.getY() - selfPos.getY()), (int)(dz = fromPos.getZ() - selfPos.getZ()));
        if (dir == Direction.UP || dir == Direction.DOWN || dir == selfState.getValue((Property)FACING)) {
            return;
        }
        this.updateOutputBeltConnectionStateOfDirection(level, selfPos, selfState, dir);
    }

    public void onPlace(BlockState selfState, Level level, BlockPos selfPos, BlockState oldState, boolean isMoving) {
        if (level.isClientSide()) {
            return;
        }
        Direction facing = (Direction)selfState.getValue((Property)FACING);
        for (int i = 0; i < 3; ++i) {
            this.updateOutputBeltConnectionStateOfDirection(level, selfPos, selfState, switch (i) {
                case 0 -> facing.getClockWise();
                case 1 -> facing.getOpposite();
                case 2 -> facing.getCounterClockWise();
                default -> null;
            });
        }
    }

    private void updateOutputBeltConnectionStateOfDirection(Level level, BlockPos blockPos, BlockState state, Direction outputBeltDirection) {
        int index;
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (outputBeltDirection == facing.getClockWise()) {
            index = 0;
        } else if (outputBeltDirection == facing.getOpposite()) {
            index = 1;
        } else if (outputBeltDirection == facing.getCounterClockWise()) {
            index = 2;
        } else {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof ItemConveyorBeltSorterBlockEntity)) {
            return;
        }
        ItemConveyorBeltSorterBlockEntity itemConveyorBeltSorterBlockEntity = (ItemConveyorBeltSorterBlockEntity)blockEntity;
        BlockState outputBeltState = level.getBlockState(blockPos.relative(outputBeltDirection));
        itemConveyorBeltSorterBlockEntity.setOutputBeltConnected(index, outputBeltState.getBlock() instanceof ItemConveyorBeltBlock);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{POWERED, FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ItemConveyorBeltSorterBlock.createTickerHelper(type, this.tier.getItemConveyorBeltSorterBlockEntityFromTier(), ItemConveyorBeltSorterBlockEntity::tick);
    }
}

