/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.serialization.MapCodec;
import java.util.function.ToIntFunction;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.EnergizerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class EnergizerBlock
extends BaseEntityBlock {
    public static final MapCodec<EnergizerBlock> CODEC = EnergizerBlock.simpleCodec(EnergizerBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = state -> (Boolean)state.getValue((Property)LIT) != false ? 8 : 0;

    protected EnergizerBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new EnergizerBlockEntity(blockPos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof EnergizerBlockEntity)) {
            return super.getAnalogOutputSignal(state, level, blockPos);
        }
        EnergizerBlockEntity energizerBlockEntity = (EnergizerBlockEntity)blockEntity;
        return energizerBlockEntity.getRedstoneOutput();
    }

    public void onRemove(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (state.getBlock() == newState.getBlock()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof EnergizerBlockEntity)) {
            return;
        }
        ((EnergizerBlockEntity)blockEntity).drops(level, blockPos);
        super.onRemove(state, level, blockPos, newState, isMoving);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos blockPos, Player player, BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof EnergizerBlockEntity)) {
            throw new IllegalStateException("Container is invalid");
        }
        player.openMenu((MenuProvider)((EnergizerBlockEntity)blockEntity), blockPos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void neighborChanged(BlockState selfState, Level level, BlockPos selfPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(selfState, level, selfPos, fromBlock, fromPos, isMoving);
        if (level.isClientSide()) {
            return;
        }
        boolean isPowered = level.hasNeighborSignal(selfPos);
        if (isPowered != (Boolean)selfState.getValue((Property)POWERED)) {
            level.setBlock(selfPos, (BlockState)selfState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 3);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{POWERED, FACING, LIT});
    }

    public void animateTick(BlockState state, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            double x = (double)blockPos.getX() + 0.5;
            double y = (double)blockPos.getY() + 0.4;
            double z = (double)blockPos.getZ() + 0.5;
            Direction facing = (Direction)state.getValue((Property)FACING);
            for (Direction direction : Direction.values()) {
                if (direction.getAxis() == Direction.Axis.Y) continue;
                for (int i = 0; i < (direction == facing ? 2 : 1); ++i) {
                    double dxz = randomSource.nextDouble() * 0.6 - 0.3;
                    double dx = direction.getAxis() == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : dxz;
                    double dy = randomSource.nextDouble() * 6.0 / 16.0;
                    double dz = direction.getAxis() == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : dxz;
                    level.addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, x + dx, y + dy, z + dz, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return EnergizerBlock.createTickerHelper(type, EPBlockEntities.ENERGIZER_ENTITY.get(), EnergizerBlockEntity::tick);
    }
}

