/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import me.jddev0.ep.block.entity.DrainBlockEntity;
import me.jddev0.ep.block.entity.EPBlockEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class DrainBlock
extends BaseEntityBlock {
    public static final MapCodec<DrainBlock> CODEC = DrainBlock.simpleCodec(DrainBlock::new);

    public DrainBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new DrainBlockEntity(blockPos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof DrainBlockEntity)) {
            return super.getAnalogOutputSignal(state, level, blockPos);
        }
        DrainBlockEntity drainBlockEntity = (DrainBlockEntity)blockEntity;
        return drainBlockEntity.getRedstoneOutput();
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos blockPos, Player player, BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof DrainBlockEntity)) {
            throw new IllegalStateException("Container is invalid");
        }
        player.openMenu((MenuProvider)((DrainBlockEntity)blockEntity), blockPos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return DrainBlock.createTickerHelper(type, EPBlockEntities.DRAIN_ENTITY.get(), DrainBlockEntity::tick);
    }

    public static class Item
    extends BlockItem {
        public Item(Block block, Item.Properties props) {
            super(block, props);
        }

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
            if (Screen.hasShiftDown()) {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.drain.txt.shift").withStyle(ChatFormatting.GRAY));
            } else {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
            }
        }
    }
}

