/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.WrenchConfigurable;
import me.jddev0.ep.block.entity.TransformerBlockEntity;
import me.jddev0.ep.machine.tier.TransformerTier;
import me.jddev0.ep.machine.tier.TransformerType;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableTransformerBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WrenchConfigurable {
    public static final MapCodec<ConfigurableTransformerBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.xmap(TransformerTier::valueOf, Enum::toString).fieldOf("tier").forGetter(ConfigurableTransformerBlock::getTier), (App)BlockBehaviour.Properties.CODEC.fieldOf("properties").forGetter(BlockBehaviour::properties)).apply((Applicative)instance, ConfigurableTransformerBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<EPBlockStateProperties.TransformerConnection> UP = EPBlockStateProperties.TRANSFORMER_CONNECTION_UP;
    public static final EnumProperty<EPBlockStateProperties.TransformerConnection> DOWN = EPBlockStateProperties.TRANSFORMER_CONNECTION_DOWN;
    public static final EnumProperty<EPBlockStateProperties.TransformerConnection> NORTH = EPBlockStateProperties.TRANSFORMER_CONNECTION_NORTH;
    public static final EnumProperty<EPBlockStateProperties.TransformerConnection> SOUTH = EPBlockStateProperties.TRANSFORMER_CONNECTION_SOUTH;
    public static final EnumProperty<EPBlockStateProperties.TransformerConnection> EAST = EPBlockStateProperties.TRANSFORMER_CONNECTION_EAST;
    public static final EnumProperty<EPBlockStateProperties.TransformerConnection> WEST = EPBlockStateProperties.TRANSFORMER_CONNECTION_WEST;
    private final TransformerTier tier;

    @NotNull
    public static EnumProperty<EPBlockStateProperties.TransformerConnection> getTransformerConnectionPropertyFromDirection(@NotNull Direction dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
        };
    }

    public ConfigurableTransformerBlock(TransformerTier tier, BlockBehaviour.Properties properties) {
        super(properties);
        this.tier = tier;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(UP, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).setValue(DOWN, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).setValue(NORTH, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).setValue(SOUTH, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).setValue(EAST, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).setValue(WEST, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED)));
    }

    public TransformerTier getTier() {
        return this.tier;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new TransformerBlockEntity(blockPos, state, this.tier, TransformerType.CONFIGURABLE);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos blockPos, Player player, BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof TransformerBlockEntity) || ((TransformerBlockEntity)blockEntity).getTier() != this.tier || ((TransformerBlockEntity)blockEntity).getTransformerType() != TransformerType.CONFIGURABLE) {
            throw new IllegalStateException("Container is invalid");
        }
        player.openMenu((MenuProvider)((TransformerBlockEntity)blockEntity), blockPos);
        return InteractionResult.SUCCESS;
    }

    @Override
    @NotNull
    public InteractionResult onUseWrench(UseOnContext useOnContext, Direction selectedFace, boolean nextPreviousValue) {
        Level level = useOnContext.getLevel();
        BlockPos blockPos = useOnContext.getClickedPos();
        if (level.isClientSide || !(level.getBlockEntity(blockPos) instanceof TransformerBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        BlockState state = level.getBlockState(blockPos);
        Player player = useOnContext.getPlayer();
        EnumProperty<EPBlockStateProperties.TransformerConnection> transformerConnectionProperty = ConfigurableTransformerBlock.getTransformerConnectionPropertyFromDirection(selectedFace);
        int diff = nextPreviousValue ? -1 : 1;
        EPBlockStateProperties.TransformerConnection transformerConnection = (EPBlockStateProperties.TransformerConnection)((Object)state.getValue(transformerConnectionProperty));
        transformerConnection = EPBlockStateProperties.TransformerConnection.values()[(transformerConnection.ordinal() + diff + EPBlockStateProperties.TransformerConnection.values().length) % EPBlockStateProperties.TransformerConnection.values().length];
        level.setBlock(blockPos, (BlockState)state.setValue(transformerConnectionProperty, (Comparable)((Object)transformerConnection)), 3);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.configurable_transformer.wrench_configuration.face_changed", (Object[])new Object[]{Component.translatable((String)("tooltip.energizedpower.direction." + selectedFace.getSerializedName())).withStyle(ChatFormatting.WHITE), Component.translatable((String)transformerConnection.getTranslationKey()).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})}).withStyle(ChatFormatting.GREEN)));
        }
        level.invalidateCapabilities(blockPos);
        return InteractionResult.SUCCESS;
    }

    public void neighborChanged(BlockState selfState, Level level, BlockPos selfPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(selfState, level, selfPos, fromBlock, fromPos, isMoving);
        if (level.isClientSide()) {
            return;
        }
        boolean isPowered = level.hasNeighborSignal(selfPos);
        if (isPowered != (Boolean)selfState.getValue((Property)POWERED)) {
            level.setBlock(selfPos, (BlockState)selfState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 3);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())))).setValue(UP, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).setValue(DOWN, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).setValue(NORTH, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).setValue(SOUTH, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).setValue(EAST, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED))).setValue(WEST, (Comparable)((Object)EPBlockStateProperties.TransformerConnection.NOT_CONNECTED));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(WEST)))))).setValue(SOUTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(EAST)))))).setValue(EAST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(NORTH)))))).setValue(WEST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(SOUTH)))));
            }
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(SOUTH)))))).setValue(SOUTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(NORTH)))))).setValue(EAST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(WEST)))))).setValue(WEST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(EAST)))));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(EAST)))))).setValue(SOUTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(WEST)))))).setValue(EAST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(SOUTH)))))).setValue(WEST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(NORTH)))));
            }
        }
        return state;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(SOUTH)))))).setValue(SOUTH, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(NORTH)))));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue(EAST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(WEST)))))).setValue(WEST, (Comparable)((Object)((EPBlockStateProperties.TransformerConnection)((Object)state.getValue(EAST)))));
            }
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{POWERED}).add(new Property[]{UP}).add(new Property[]{DOWN}).add(new Property[]{NORTH}).add(new Property[]{SOUTH}).add(new Property[]{EAST}).add(new Property[]{WEST});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ConfigurableTransformerBlock.createTickerHelper(type, this.tier.getEntityTypeFromTierAndType(TransformerType.CONFIGURABLE), TransformerBlockEntity::tick);
    }

    public static class Item
    extends BlockItem {
        private final TransformerTier tier;

        public Item(Block block, Item.Properties props, TransformerTier tier) {
            super(block, props);
            this.tier = tier;
        }

        public TransformerTier getTier() {
            return this.tier;
        }

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
            if (Screen.hasShiftDown()) {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.wrench_configurable").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.transfer_rate.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(this.tier.getMaxEnergyTransferFromTier())}).withStyle(ChatFormatting.GRAY));
                components.add((Component)Component.empty());
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.transformer.txt.shift.1").withStyle(ChatFormatting.GRAY));
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.transformer.txt.shift.2").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.transformer.txt.shift.3").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
            }
        }
    }
}

