/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.serialization.MapCodec;
import me.jddev0.ep.block.entity.AutoPressMoldMakerBlockEntity;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.WorkerMachineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class AutoPressMoldMakerBlock
extends BaseEntityBlock {
    public static final MapCodec<AutoPressMoldMakerBlock> CODEC = AutoPressMoldMakerBlock.simpleCodec(AutoPressMoldMakerBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public AutoPressMoldMakerBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new AutoPressMoldMakerBlockEntity(blockPos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof AutoPressMoldMakerBlockEntity)) {
            return super.getAnalogOutputSignal(state, level, blockPos);
        }
        AutoPressMoldMakerBlockEntity autoPressMoldMakerBlockEntity = (AutoPressMoldMakerBlockEntity)blockEntity;
        return autoPressMoldMakerBlockEntity.getRedstoneOutput();
    }

    public void onRemove(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (state.getBlock() == newState.getBlock()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof AutoPressMoldMakerBlockEntity)) {
            return;
        }
        ((AutoPressMoldMakerBlockEntity)blockEntity).drops(level, blockPos);
        super.onRemove(state, level, blockPos, newState, isMoving);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos blockPos, Player player, BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof AutoPressMoldMakerBlockEntity)) {
            throw new IllegalStateException("Container is invalid");
        }
        player.openMenu((MenuProvider)((AutoPressMoldMakerBlockEntity)blockEntity), blockPos);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void neighborChanged(BlockState selfState, Level level, BlockPos selfPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(selfState, level, selfPos, fromBlock, fromPos, isMoving);
        if (level.isClientSide()) {
            return;
        }
        boolean isPowered = level.hasNeighborSignal(selfPos);
        if (isPowered != (Boolean)selfState.getValue((Property)POWERED)) {
            level.setBlock(selfPos, (BlockState)selfState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 3);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{POWERED});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return AutoPressMoldMakerBlock.createTickerHelper(type, EPBlockEntities.AUTO_PRESS_MOLD_MAKER_ENTITY.get(), WorkerMachineBlockEntity::tick);
    }
}

