/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.rpg_series.tags;

import java.util.LinkedHashMap;
import java.util.Locale;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.spell_engine.api.item.Equipment;

public class RPGSeriesItemTags {
    public static final String NAMESPACE = "rpg_series";

    public static class LootTiers {
        public static final int DEFAULT_TIERS = 10;
        public static final String FOLDER = "loot_tier";

        public static TagKey<Item> get(int tier, LootCategory category) {
            return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)LootTiers.id(tier, category));
        }

        public static ResourceLocation id(int tier, LootCategory category) {
            String name = category.toString().toLowerCase(Locale.ROOT);
            return ResourceLocation.fromNamespaceAndPath((String)RPGSeriesItemTags.NAMESPACE, (String)("loot_tier/tier_" + tier + "_" + name));
        }
    }

    public static enum LootCategory {
        WEAPONS,
        ARMORS,
        ACCESSORIES,
        RELICS;

    }

    public static class LootThemes {
        public static final String FOLDER = "loot_theme";
        public static final LinkedHashMap<LootTheme, TagKey<Item>> ALL = new LinkedHashMap();

        public static TagKey<Item> get(String theme) {
            return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)LootThemes.id(theme.toLowerCase(Locale.ROOT)));
        }

        public static ResourceLocation id(LootTheme theme) {
            return LootThemes.id(theme.toString().toLowerCase(Locale.ROOT));
        }

        public static ResourceLocation id(String theme) {
            return ResourceLocation.fromNamespaceAndPath((String)RPGSeriesItemTags.NAMESPACE, (String)("loot_theme/" + theme));
        }

        static {
            for (LootTheme theme : LootTheme.values()) {
                ResourceLocation id = LootThemes.id(theme.toString().toLowerCase(Locale.ROOT));
                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id);
                ALL.put(theme, (TagKey<Item>)tag);
            }
        }
    }

    public static enum LootTheme {
        DRAGON,
        AETHER,
        GOLDEN_WEAPON;

    }

    public static class Archetype {
        public static final String FOLDER = "archetype";
        public static final LinkedHashMap<RoleArchetype, TagKey<Item>> TAGS = new LinkedHashMap();

        public static ResourceLocation id(RoleArchetype archetype) {
            return ResourceLocation.fromNamespaceAndPath((String)RPGSeriesItemTags.NAMESPACE, (String)("archetype/" + archetype.toString().toLowerCase(Locale.ROOT) + "_weapon"));
        }

        public static String tagString(RoleArchetype archetype) {
            return "#" + String.valueOf(Archetype.id(archetype));
        }

        public static TagKey<Item> tag(RoleArchetype archetype) {
            return TAGS.get((Object)archetype);
        }

        public static RoleArchetype classify(Equipment.WeaponType category) {
            switch (category) {
                case DAMAGE_STAFF: 
                case DAMAGE_WAND: 
                case SPELL_SCYTHE: 
                case SPELL_BLADE: {
                    return RoleArchetype.MAGIC_DAMAGE;
                }
                case HEALING_STAFF: 
                case HEALING_WAND: {
                    return RoleArchetype.HEALING;
                }
                case SHORT_BOW: 
                case LONG_BOW: 
                case RAPID_CROSSBOW: 
                case HEAVY_CROSSBOW: {
                    return RoleArchetype.RANGED_DAMAGE;
                }
                case CLAYMORE: 
                case MACE: 
                case HAMMER: 
                case SPEAR: 
                case DAGGER: 
                case SICKLE: 
                case DOUBLE_AXE: 
                case GLAIVE: {
                    return RoleArchetype.MELEE_DAMAGE;
                }
                case SHIELD: {
                    return RoleArchetype.DEFENSE;
                }
            }
            return null;
        }

        static {
            for (RoleArchetype archetype : RoleArchetype.values()) {
                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Archetype.id(archetype));
                TAGS.put(archetype, (TagKey<Item>)tag);
            }
        }
    }

    public static enum RoleArchetype {
        MELEE_DAMAGE,
        RANGED_DAMAGE,
        MAGIC_DAMAGE,
        DEFENSE,
        HEALING;

    }

    public static class ArmorType {
        public static final String FOLDER = "armor_type";
        public static final LinkedHashMap<ArmorMetaType, TagKey<Item>> ALL = new LinkedHashMap();

        public static ResourceLocation id(ArmorMetaType category) {
            return ResourceLocation.fromNamespaceAndPath((String)RPGSeriesItemTags.NAMESPACE, (String)("armor_type/" + category.toString().toLowerCase(Locale.ROOT)));
        }

        public static TagKey<Item> get(ArmorMetaType category) {
            return ALL.get((Object)category);
        }

        static {
            for (ArmorMetaType category : ArmorMetaType.values()) {
                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ArmorType.id(category));
                ALL.put(category, (TagKey<Item>)tag);
            }
        }
    }

    public static enum ArmorMetaType {
        MELEE,
        MAGIC,
        ARCHERY;

    }

    public static class WeaponType {
        public static final String FOLDER = "weapon_type";
        public static final LinkedHashMap<Equipment.WeaponType, TagKey<Item>> ALL = new LinkedHashMap();

        public static TagKey<Item> get(Equipment.WeaponType category) {
            return ALL.get((Object)category);
        }

        static {
            for (Equipment.WeaponType category : Equipment.WeaponType.values()) {
                ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)RPGSeriesItemTags.NAMESPACE, (String)("weapon_type/" + category.toString().toLowerCase(Locale.ROOT)));
                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id);
                ALL.put(category, (TagKey<Item>)tag);
            }
        }
    }
}

