/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.effect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.spell_engine.api.effect.Synchronized;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityStatusEffectSync
extends Entity
implements Synchronized.Provider {
    @Shadow
    @Final
    private Map<Holder<MobEffect>, MobEffectInstance> activeEffects;
    private final ArrayList<Synchronized.Effect> SpellEngine_syncedStatusEffects = new ArrayList();
    private static final EntityDataAccessor<String> SPELL_ENGINE_SYNCED_EFFECTS = SynchedEntityData.defineId(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public LivingEntityStatusEffectSync(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at={@At(value="TAIL")})
    private void initDataTracker_TAIL_SpellEngine_SyncEffects(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(SPELL_ENGINE_SYNCED_EFFECTS, (Object)"");
    }

    @Inject(method={"updateInvisibilityStatus()V"}, at={@At(value="HEAD")})
    private void updatePotionVisibility_HEAD_SpellEngine_SyncEffects(CallbackInfo ci) {
        if (this.activeEffects.isEmpty()) {
            this.entityData.set(SPELL_ENGINE_SYNCED_EFFECTS, (Object)"");
        } else {
            this.entityData.set(SPELL_ENGINE_SYNCED_EFFECTS, (Object)this.SpellEngine_encodedStatusEffects());
        }
    }

    @Inject(method={"onSyncedDataUpdated(Lnet/minecraft/network/syncher/EntityDataAccessor;)V"}, at={@At(value="TAIL")})
    private void onTrackedDataSet_TAIL_SpellEngine_SyncEffects(EntityDataAccessor<?> data, CallbackInfo ci) {
        if (SPELL_ENGINE_SYNCED_EFFECTS.equals(data)) {
            this.SpellEngine_syncedStatusEffects.clear();
            this.SpellEngine_syncedStatusEffects.addAll(this.SpellEngine_decodeStatusEffects());
        }
    }

    private String SpellEngine_encodedStatusEffects() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Map.Entry<Holder<MobEffect>, MobEffectInstance> entry : this.activeEffects.entrySet()) {
            MobEffect effect = (MobEffect)entry.getKey().value();
            if (!((Synchronized)effect).shouldSynchronize()) continue;
            int id = BuiltInRegistries.MOB_EFFECT.getId((Object)effect);
            int amplifier = entry.getValue().getAmplifier();
            if (i > 0) {
                builder.append("-");
            }
            builder.append(id).append(":").append(amplifier);
            ++i;
        }
        return builder.toString();
    }

    private List<Synchronized.Effect> SpellEngine_decodeStatusEffects() {
        String string = (String)this.entityData.get(SPELL_ENGINE_SYNCED_EFFECTS);
        ArrayList<Synchronized.Effect> effects = new ArrayList<Synchronized.Effect>();
        for (String effect : string.split("-")) {
            String[] components = effect.split(":");
            if (components.length != 2) continue;
            int rawId = Integer.valueOf(components[0]);
            int amplifier = Integer.valueOf(components[1]);
            MobEffect statusEffect = (MobEffect)BuiltInRegistries.MOB_EFFECT.byId(rawId);
            if (statusEffect == null) continue;
            effects.add(new Synchronized.Effect(statusEffect, amplifier));
        }
        return effects;
    }

    @Override
    public List<Synchronized.Effect> SpellEngine_syncedStatusEffects() {
        return this.SpellEngine_syncedStatusEffects;
    }
}

