/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.effect;

import java.util.HashMap;
import net.minecraft.world.entity.Entity;
import net.spell_engine.api.effect.EntityImmunity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityImmunityMixin
implements EntityImmunity {
    private final HashMap<EntityImmunity.Type, Integer> immunity = EntityImmunityMixin.immunityDefaults();

    private static HashMap<EntityImmunity.Type, Integer> immunityDefaults() {
        HashMap<EntityImmunity.Type, Integer> map = new HashMap<EntityImmunity.Type, Integer>();
        for (EntityImmunity.Type type : EntityImmunity.Type.values()) {
            map.put(type, 0);
        }
        return map;
    }

    @Override
    public boolean isImmuneTo(EntityImmunity.Type type) {
        return this.immunity.get((Object)type) > 0;
    }

    @Override
    public void setImmuneTo(EntityImmunity.Type type, int ticks) {
        this.immunity.put(type, ticks);
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void tick_TAIL_SpellEngine_Immunity(CallbackInfo ci) {
        for (EntityImmunity.Type type : EntityImmunity.Type.values()) {
            Integer ticks = this.immunity.get((Object)type);
            if (ticks <= 0) continue;
            this.immunity.put(type, ticks - 1);
        }
    }

    @Inject(method={"ignoreExplosion(Lnet/minecraft/world/level/Explosion;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isImmuneToExplosion(CallbackInfoReturnable<Boolean> cir) {
        if (this.isImmuneTo(EntityImmunity.Type.EXPLOSION)) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }
}

