/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.container.SpellContainerSource;
import net.spell_engine.utils.PatternMatching;
import net.spell_power.api.SpellSchool;

public class SpellModifiers {
    public static List<Spell.Modifier> of(Player player, Holder<Spell> spellEntry) {
        ResourceLocation spellId = ((ResourceKey)spellEntry.unwrapKey().get()).location();
        SpellContainerSource.Owner owner = (SpellContainerSource.Owner)player;
        List<Spell.Modifier> matchingModifiers = owner.spellModifierCache().get(spellId);
        if (matchingModifiers == null) {
            matchingModifiers = new ArrayList<Spell.Modifier>();
            SpellContainerSource.Result containers = owner.getSpellContainers();
            if (containers != null) {
                for (Holder<Spell> entry : containers.modifiers()) {
                    Spell spell = (Spell)entry.value();
                    for (Spell.Modifier modifier : spell.modifiers) {
                        if (!PatternMatching.matches(spellEntry, SpellRegistry.KEY, modifier.spell_pattern)) continue;
                        matchingModifiers.add(modifier);
                    }
                }
            }
            owner.spellModifierCache().put(spellId, matchingModifiers);
        }
        return matchingModifiers;
    }

    public static List<Spell.Modifier> ofImpact(Player player, Holder<Spell> spellEntry, Spell.Impact impact) {
        return SpellModifiers.of(player, spellEntry).stream().filter(modifier -> {
            for (Spell.Modifier.ImpactFilter filter : modifier.impact_filters) {
                if (SpellModifiers.impactMatches(impact, spellEntry, filter)) continue;
                return false;
            }
            return true;
        }).toList();
    }

    private static boolean impactMatches(Spell.Impact impact, Holder<Spell> spellEntry, Spell.Modifier.ImpactFilter filter) {
        if (filter.school != null) {
            SpellSchool school;
            SpellSchool spellSchool = school = impact.school != null ? impact.school : ((Spell)spellEntry.value()).school;
            if (school != filter.school) {
                return false;
            }
        }
        return filter.type == null || impact.action.type == filter.type;
    }

    public static float cooldownDeduction(Player player, Holder<Spell> spellEntry) {
        List<Spell.Modifier> modifiers = SpellModifiers.of(player, spellEntry);
        float value = 0.0f;
        for (Spell.Modifier modifier : modifiers) {
            value += modifier.cooldown_duration_deduct;
        }
        return value;
    }
}

