/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.casting.SpellCasterEntity;
import org.jetbrains.annotations.Nullable;

public class SpellEngineCommands {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spell_cooldown").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"reset").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"spell", (ArgumentType)ResourceArgument.resource((CommandBuildContext)registryAccess, SpellRegistry.KEY)).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            Holder.Reference spell = ResourceArgument.getResource((CommandContext)context, (String)"spell", SpellRegistry.KEY);
            return SpellEngineCommands.executeResetCooldown(players, (Holder<Spell>)spell);
        }))))).then(Commands.literal((String)"clear").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            return SpellEngineCommands.executeResetCooldown(players, null);
        })))));
    }

    private static int executeResetCooldown(Collection<ServerPlayer> players, @Nullable Holder<Spell> spell) {
        for (ServerPlayer player : players) {
            ResourceLocation spellId = null;
            if (spell != null) {
                spellId = ((ResourceKey)spell.unwrapKey().get()).location();
            }
            ((SpellCasterEntity)player).getCooldownManager().reset(spellId);
        }
        return 0;
    }
}

