/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SnowflakeParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.spell_engine.client.util.Color;
import net.spell_power.api.SpellSchools;

@OnlyIn(value=Dist.CLIENT)
public class SpellSnowflakeParticle
extends SnowflakeParticle {
    boolean glow = true;

    protected SpellSnowflakeParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ, spriteProvider);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public int getLightColor(float tint) {
        if (this.glow) {
            return 255;
        }
        return super.getLightColor(tint);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RootsFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public static Color color = Color.from(SpellSchools.FROST.color);

        public RootsFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellSnowflakeParticle particle = new SpellSnowflakeParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            particle.setColor(1.0f, 1.0f, 1.0f);
            particle.alpha = 1.0f;
            particle.glow = false;
            particle.setSize(3.0f, 3.0f);
            particle.xd = 0.0;
            particle.zd = 0.0;
            particle.quadSize = 0.25f;
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DrippingBloodFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public static Color color = Color.from(0xB30000);

        public DrippingBloodFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellSnowflakeParticle particle = new SpellSnowflakeParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            particle.setColor(0.35f, 0.0f, 0.0f);
            particle.alpha = 1.0f;
            particle.glow = false;
            particle.xd *= 0.4;
            particle.zd *= 0.4;
            particle.gravity = 0.8f;
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class HolyFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public static Color color = Color.from(0xFFFFCC);

        public HolyFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellSnowflakeParticle particle = new SpellSnowflakeParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            particle.setColor(color.red(), color.green(), color.red());
            particle.alpha = 0.75f;
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FrostFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public static Color color = Color.from(SpellSchools.FROST.color);

        public FrostFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellSnowflakeParticle particle = new SpellSnowflakeParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            particle.setColor(color.red(), color.green(), color.red());
            particle.alpha = 0.75f;
            return particle;
        }
    }
}

