/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import net.spell_engine.api.spell.Spell;
import org.jetbrains.annotations.Nullable;

public class SpellRegistry {
    public static final ResourceLocation ID = ResourceLocation.withDefaultNamespace((String)"spell");
    public static final ResourceKey<Registry<Spell>> KEY = ResourceKey.createRegistryKey((ResourceLocation)ID);
    private static final Gson gson = new GsonBuilder().create();
    public static final Codec<Spell> LOCAL_CODEC = ExtraCodecs.JSON.xmap(json -> (Spell)gson.fromJson(json, Spell.class), spell -> {
        JsonElement jsonElement = gson.toJsonTree(spell);
        return jsonElement;
    });
    public static final Codec<Spell> NETWORK_CODEC_V2 = Codec.BYTE_BUFFER.comapFlatMap(encoded -> {
        byte[] bytes = encoded.array();
        String json = new String(bytes);
        Spell spell = (Spell)gson.fromJson(json, Spell.class);
        return DataResult.success((Object)spell);
    }, spell -> {
        String json = gson.toJson(spell);
        byte[] bytes = json.getBytes();
        return ByteBuffer.wrap(bytes);
    });
    public static final Codec<Spell> NETWORK_CODEC = Codec.STRING.comapFlatMap(encoded -> {
        byte[] bytes = encoded.getBytes();
        String json = new String(Base64.getDecoder().decode(bytes));
        Spell spell = (Spell)gson.fromJson(json, Spell.class);
        return DataResult.success((Object)spell);
    }, spell -> {
        String json = gson.toJson(spell);
        byte[] bytes = json.getBytes();
        return Base64.getEncoder().encodeToString(bytes);
    });

    public static Registry<Spell> from(Level world) {
        return world.registryAccess().registryOrThrow(KEY);
    }

    public static HolderSet.Named<Spell> find(Level world, ResourceLocation tagId) {
        RegistryAccess manager = world.registryAccess();
        HolderGetter lookup = manager.asGetterLookup().lookupOrThrow(KEY);
        TagKey tag = TagKey.create(KEY, (ResourceLocation)tagId);
        return lookup.getOrThrow(tag);
    }

    public static List<Holder<Spell>> entries(Level world, @Nullable ResourceLocation id) {
        try {
            return SpellRegistry.find(world, id).stream().toList();
        }
        catch (Exception e) {
            return List.of();
        }
    }

    public static List<Holder<Spell>> entries(Level world, @Nullable String pool) {
        if (pool == null || pool.isEmpty()) {
            return List.of();
        }
        ResourceLocation id = ResourceLocation.parse((String)pool);
        return SpellRegistry.entries(world, id);
    }

    public static Stream<Holder.Reference<Spell>> stream(Level world) {
        RegistryAccess manager = world.registryAccess();
        Registry registry = manager.registryOrThrow(KEY);
        return registry.holders();
    }
}

