/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item.weapon;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.spell_engine.api.config.WeaponConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.Tiers;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import org.jetbrains.annotations.Nullable;

public class Weapon {
    private static final ResourceLocation equipmentBonusId = ResourceLocation.parse((String)"equipment_bonus");
    private static final ResourceLocation attackDamageId = ResourceLocation.parse((String)"generic.attack_damage");
    private static final ResourceLocation projectileDamageId = ResourceLocation.fromNamespaceAndPath((String)"projectile_damage", (String)"generic");

    public static void register(Map<String, WeaponConfig> configs, List<Entry> entries, ResourceKey<CreativeModeTab> itemGroupKey) {
        for (Entry entry : entries) {
            int tier;
            WeaponConfig config = configs.get(entry.name);
            if (config == null) {
                config = entry.defaults;
                configs.put(entry.name(), config);
            }
            if (!entry.isRequiredModInstalled()) continue;
            Item.Properties settings = new Item.Properties().attributes(Weapon.attributesFrom(config));
            if (entry.rarity != Rarity.COMMON) {
                settings = settings.rarity(entry.rarity);
            }
            if (entry.spells != null) {
                if (entry.spells.isEmpty()) {
                    settings.component(SpellDataComponents.SPELL_CONTAINER, (Object)SpellContainerHelper.createForMagicWeapon());
                } else {
                    settings.component(SpellDataComponents.SPELL_CONTAINER, (Object)SpellContainerHelper.createForWeapon(SpellContainer.ContentType.MAGIC, entry.spells));
                }
            }
            if ((tier = Tiers.unsafe(entry.id())) >= 3) {
                settings.fireResistant();
            }
            Item item = entry.create(entry.material, settings);
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id(), (Object)item);
        }
        ItemGroupEvents.modifyEntriesEvent(itemGroupKey).register(content -> {
            for (Entry entry : entries) {
                content.accept((ItemLike)entry.item());
            }
        });
    }

    public static ItemAttributeModifiers attributesFrom(WeaponConfig config) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)config.attack_damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)config.attack_speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        for (net.spell_engine.api.config.AttributeModifier attribute : config.selectedAttributes()) {
            try {
                ResourceLocation attributeId = ResourceLocation.parse((String)attribute.attribute);
                Holder.Reference entityAttribute = (Holder.Reference)BuiltInRegistries.ATTRIBUTE.getHolder(attributeId).get();
                builder.add((Holder)entityAttribute, new AttributeModifier(equipmentBonusId, (double)attribute.value, attribute.operation), EquipmentSlotGroup.MAINHAND);
            }
            catch (Exception e) {
                System.err.println("Failed to add item attribute modifier: " + e.getMessage());
            }
        }
        return builder.build();
    }

    public static ItemAttributeModifiers attributesFrom(List<net.spell_engine.api.config.AttributeModifier> attributes) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        for (net.spell_engine.api.config.AttributeModifier attribute : attributes) {
            try {
                ResourceLocation attributeId = ResourceLocation.parse((String)attribute.attribute);
                Holder.Reference entityAttribute = (Holder.Reference)BuiltInRegistries.ATTRIBUTE.getHolder(attributeId).get();
                builder.add((Holder)entityAttribute, new AttributeModifier(equipmentBonusId, (double)attribute.value, attribute.operation), EquipmentSlotGroup.MAINHAND);
            }
            catch (Exception e) {
                System.err.println("Failed to add item attribute modifier: " + e.getMessage());
            }
        }
        return builder.build();
    }

    public static final class Entry {
        private final String namespace;
        private final String name;
        private final CustomMaterial material;
        private final Factory factory;
        @Nullable
        private Item registeredItem;
        private final WeaponConfig defaults;
        @Nullable
        private String requiredMod;
        public Rarity rarity = Rarity.COMMON;
        private String translatedName = "";
        public String weaponAttributesPreset = "";
        public List<ResourceLocation> spells = null;
        public Equipment.WeaponType category = Equipment.WeaponType.SWORD;
        public Equipment.LootProperties lootProperties = Equipment.LootProperties.EMPTY;

        public Entry(String namespace, String name, CustomMaterial material, Factory factory, WeaponConfig defaults, Equipment.WeaponType category) {
            this.namespace = namespace;
            this.name = name;
            this.material = material;
            this.factory = factory;
            this.defaults = defaults;
            this.category = category;
        }

        public ResourceLocation id() {
            return ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)this.name);
        }

        public Entry attribute(net.spell_engine.api.config.AttributeModifier attribute) {
            this.defaults.add(attribute);
            return this;
        }

        public Entry requires(String modName) {
            this.requiredMod = modName;
            return this;
        }

        public boolean isRequiredModInstalled() {
            if (this.requiredMod == null || this.requiredMod.isEmpty()) {
                return true;
            }
            return FabricLoader.getInstance().isModLoaded(this.requiredMod);
        }

        public String name() {
            return this.name;
        }

        public CustomMaterial material() {
            return this.material;
        }

        public Item create(Tier material, Item.Properties settings) {
            Item item;
            this.registeredItem = item = this.factory.create(material, settings);
            return item;
        }

        @Nullable
        public Item item() {
            return this.registeredItem;
        }

        public WeaponConfig defaults() {
            return this.defaults;
        }

        @Deprecated
        public Entry tier(int tier) {
            return this;
        }

        @Deprecated
        public int tier() {
            return 0;
        }

        public Entry castSpell() {
            this.spells = List.of();
            return this;
        }

        public Entry spell(ResourceLocation spellId) {
            this.spells = List.of(spellId);
            return this;
        }

        public Entry translatedName(String name) {
            this.translatedName = name;
            return this;
        }

        public String translatedName() {
            return this.translatedName;
        }

        public Equipment.WeaponType category() {
            return this.category;
        }

        public Entry loot(Equipment.LootProperties properties) {
            this.lootProperties = properties;
            return this;
        }

        public Equipment.LootProperties lootProperties() {
            return this.lootProperties;
        }
    }

    public static class CustomMaterial
    implements Tier {
        private TagKey<Block> inverseTag;
        private int durability = 0;
        private float miningSpeed = 0.0f;
        private int enchantability = 0;
        private LazyLoadedValue<Ingredient> ingredient = null;

        public static CustomMaterial matching(net.minecraft.world.item.Tiers vanillaMaterial, Supplier<Ingredient> repairIngredient) {
            CustomMaterial material = new CustomMaterial();
            material.durability = vanillaMaterial.getUses();
            material.miningSpeed = vanillaMaterial.getSpeed();
            material.enchantability = vanillaMaterial.getEnchantmentValue();
            material.ingredient = new LazyLoadedValue(repairIngredient);
            material.inverseTag = vanillaMaterial.getIncorrectBlocksForDrops();
            return material;
        }

        public int getUses() {
            return this.durability;
        }

        public float getSpeed() {
            return this.miningSpeed;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return this.inverseTag;
        }

        public int getEnchantmentValue() {
            return this.enchantability;
        }

        public Ingredient getRepairIngredient() {
            return (Ingredient)this.ingredient.get();
        }

        public Tool createToolProperties(TagKey<Block> tag) {
            return super.createToolProperties(tag);
        }
    }

    public static interface Factory {
        public Item create(Tier var1, Item.Properties var2);
    }
}

