/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.paladins.content.PaladinSpells;
import net.paladins.datagen.PaladinRecipes;
import net.paladins.item.PaladinWeapons;
import net.paladins.item.Shields;
import net.paladins.item.armor.Armors;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;

public class PaladinsDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(SpellGen::new);
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(UnsmeltGenerator::new);
        pack.addProvider(PaladinRecipes::new);
    }

    public static class UnsmeltGenerator
    extends FabricRecipeProvider {
        public static int UNSMELT_TIME = 300;

        public UnsmeltGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        public void buildRecipes(RecipeOutput exporter) {
            UnsmeltGenerator.disassembleArmor(exporter, Armors.paladinArmorSet_t1, Items.IRON_NUGGET);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.paladinArmorSet_t2, Items.GOLD_NUGGET);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.paladinArmorSet_t3, Items.NETHERITE_SCRAP);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.priestArmorSet_t1, Items.IRON_NUGGET);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.priestArmorSet_t2, Items.GOLD_NUGGET);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.priestArmorSet_t3, Items.NETHERITE_SCRAP);
            UnsmeltGenerator.disassemble(exporter, PaladinWeapons.entries.stream().filter(entry -> entry.id().getPath().contains("gold")).map(entry -> entry.item()).toList(), Items.GOLD_NUGGET);
            UnsmeltGenerator.disassemble(exporter, PaladinWeapons.entries.stream().filter(entry -> entry.id().getPath().contains("iron")).map(entry -> entry.item()).toList(), Items.IRON_NUGGET);
            UnsmeltGenerator.disassemble(exporter, PaladinWeapons.entries.stream().filter(entry -> entry.id().getPath().contains("netherite")).map(entry -> entry.item()).toList(), Items.NETHERITE_SCRAP);
            UnsmeltGenerator.disassemble(exporter, List.of(PaladinWeapons.holy_staff.item(), PaladinWeapons.holy_wand.item()), Items.GOLD_NUGGET);
            UnsmeltGenerator.disassemble(exporter, List.of(Shields.iron_kite_shield.holder().item), Items.IRON_NUGGET);
            UnsmeltGenerator.disassemble(exporter, List.of(Shields.golden_kite_shield.holder().item), Items.GOLD_NUGGET);
            UnsmeltGenerator.disassemble(exporter, List.of(Shields.netherite_kite_shield.holder().item), Items.NETHERITE_SCRAP);
        }

        private static void disassembleArmor(RecipeOutput exporter, Armor.Set armorSet, Item output) {
            FabricRecipeProvider.oreSmelting((RecipeOutput)exporter, (List)armorSet.pieces(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.oreBlasting((RecipeOutput)exporter, (List)armorSet.pieces(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }

        private static void disassemble(RecipeOutput exporter, List<ItemLike> items, Item output) {
            FabricRecipeProvider.oreSmelting((RecipeOutput)exporter, items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.oreBlasting((RecipeOutput)exporter, items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void addTags(HolderLookup.Provider wrapperLookup) {
            this.generateWeaponTags(PaladinWeapons.entries);
            this.generateArmorTags(Armors.entries.stream().filter(entry -> entry.name().contains("armor")).toList(), RPGSeriesItemTags.ArmorMetaType.MELEE);
            this.generateArmorTags(Armors.entries.stream().filter(entry -> entry.name().contains("robe")).toList(), RPGSeriesItemTags.ArmorMetaType.MAGIC);
            List<RPGSeriesDataGen.ShieldEntry> shieldEntries = Shields.ENTRIES.stream().map(entry -> new RPGSeriesDataGen.ShieldEntry(entry.id(), entry.lootProperties())).toList();
            this.generateShieldTags(shieldEntries);
        }
    }

    public static class SpellGen
    extends SpellGenerator {
        public SpellGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (PaladinSpells.Entry entry : PaladinSpells.entries) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }
}

