/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.content;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PaladinSounds {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static final Entry paladin_armor_equip = PaladinSounds.add(new Entry("plate_equip").variants(3));
    public static final Entry priest_robe_equip = PaladinSounds.add(new Entry("cloth_equip").variants(3));
    public static final Entry shield_equip = PaladinSounds.add(new Entry("shield_equip"));
    public static final Entry holy_barrier_activate = PaladinSounds.add(new Entry("holy_barrier_activate"));
    public static final Entry holy_barrier_idle = PaladinSounds.add(new Entry("holy_barrier_idle"));
    public static final Entry holy_barrier_impact = PaladinSounds.add(new Entry("holy_barrier_impact"));
    public static final Entry holy_barrier_deactivate = PaladinSounds.add(new Entry("holy_barrier_deactivate"));
    public static final Entry divine_protection_release = PaladinSounds.add(new Entry("divine_protection_release"));
    public static final Entry judgement_impact = PaladinSounds.add(new Entry("judgement_impact").travelDistance(48.0f));
    public static final Entry divine_protection_impact = PaladinSounds.add(new Entry("divine_protection_impact"));
    public static final Entry battle_banner_release = PaladinSounds.add(new Entry("battle_banner_release"));
    public static final Entry battle_banner_presence = PaladinSounds.add(new Entry("battle_banner_presence"));
    public static final Entry holy_shock_damage = PaladinSounds.add(new Entry("holy_shock_damage"));
    public static final Entry holy_shock_heal = PaladinSounds.add(new Entry("holy_shock_heal"));
    public static final Entry holy_beam_start_casting = PaladinSounds.add(new Entry("holy_beam_start_casting"));
    public static final Entry holy_beam_casting = PaladinSounds.add(new Entry("holy_beam_casting"));
    public static final Entry holy_beam_damage = PaladinSounds.add(new Entry("holy_beam_damage"));
    public static final Entry holy_beam_heal = PaladinSounds.add(new Entry("holy_beam_heal"));
    public static final Entry holy_beam_release = PaladinSounds.add(new Entry("holy_beam_release"));

    public static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : entries) {
            entry.entry = Registry.registerForHolder((Registry)BuiltInRegistries.SOUND_EVENT, (ResourceLocation)entry.id(), (Object)entry.soundEvent());
        }
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent) {
        PaladinSounds.playSoundEvent(world, entity, soundEvent, 1.0f, 1.0f);
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent, float volume, float pitch) {
        world.playSound((Player)null, entity.getX(), entity.getY(), entity.getZ(), soundEvent, SoundSource.PLAYERS, volume, pitch);
    }

    public static final class Entry {
        private final ResourceLocation id;
        private final SoundEvent soundEvent;
        private Holder<SoundEvent> entry;
        private int variants = 1;

        public Entry(ResourceLocation id, SoundEvent soundEvent) {
            this.id = id;
            this.soundEvent = soundEvent;
        }

        public Entry(String name) {
            this(ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)name));
        }

        public Entry(ResourceLocation id) {
            this(id, SoundEvent.createVariableRangeEvent((ResourceLocation)id));
        }

        public Entry travelDistance(float distance) {
            return new Entry(this.id, SoundEvent.createFixedRangeEvent((ResourceLocation)this.id, (float)distance));
        }

        public Entry variants(int variants) {
            this.variants = variants;
            return this;
        }

        public ResourceLocation id() {
            return this.id;
        }

        public SoundEvent soundEvent() {
            return this.soundEvent;
        }

        public Holder<SoundEvent> entry() {
            return this.entry;
        }

        public int variants() {
            return this.variants;
        }
    }
}

