/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.client.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.paladins.entity.BannerEntity;
import net.spell_engine.api.render.CustomModels;
import net.spell_engine.client.util.Color;

public class BannerEntityRenderer<T extends BannerEntity>
extends EntityRenderer<T> {
    private final ItemRenderer itemRenderer;
    public static final ResourceLocation modelId = ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)"effect/battle_banner");
    private static final ResourceLocation beamTexture = ResourceLocation.parse((String)"textures/entity/beacon_beam.png");
    private static final RenderType layer = RenderType.entityTranslucent((ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
    private static Color.IntFormat innerColor = Color.IntFormat.fromLongRGBA((long)0xFF0000FFL);
    private static Color.IntFormat outerColor = Color.IntFormat.fromLongRGBA((long)0xFFCC66FFL);

    public BannerEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public ResourceLocation getTexture(T entity) {
        return null;
    }

    public void render(T entity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light) {
        super.render(entity, yaw, tickDelta, matrixStack, vertexConsumers, light);
        matrixStack.pushPose();
        matrixStack.mulPose(Axis.YP.rotationDegrees(-1.0f * entity.getYRot() + 180.0f));
        matrixStack.translate(0.0, 0.5, 0.0);
        CustomModels.render((RenderType)layer, (ItemRenderer)this.itemRenderer, (ResourceLocation)modelId, (PoseStack)matrixStack, (MultiBufferSource)vertexConsumers, (int)light, (int)entity.getId());
        matrixStack.translate(0.5, 0.0, 0.5);
        matrixStack.popPose();
    }
}

