/*
 * Decompiled with CFR 0.152.
 */
package net.arsenal.spell;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.arsenal.spell.AbsorptionStatusEffect;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConfigFile;
import net.spell_engine.api.config.EffectConfig;
import net.spell_engine.api.effect.ActionImpairing;
import net.spell_engine.api.effect.CustomStatusEffect;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.entity.SpellEngineAttributes;
import net.spell_power.api.SpellPowerMechanics;

public class ArsenalEffects {
    public static final List<Effects.Entry> entries = new ArrayList<Effects.Entry>();
    public static Effects.Entry STUN = ArsenalEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"stun"), "Stunned", "Cannot move or act.", (MobEffect)new CustomStatusEffect(MobEffectCategory.HARMFUL, 0x888800), new EffectConfig(List.of(new AttributeModifier(Attributes.JUMP_STRENGTH.getRegisteredName(), 0.0f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)))));
    public static Effects.Entry FROSTBITE = ArsenalEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"frostbite"), "Frostbite", "Slower movement and attack speed.", (MobEffect)new CustomStatusEffect(MobEffectCategory.HARMFUL, 0x99CCFF), new EffectConfig(List.of(new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), -0.25f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(Attributes.ATTACK_SPEED.getRegisteredName(), -0.25f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry GUARDING = ArsenalEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"guarding"), "Guarding", "Increased defense.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 65280), new EffectConfig(List.of(new AttributeModifier(SpellEngineAttributes.DAMAGE_TAKEN.id.toString(), -0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry SUNDERING = ArsenalEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"sundering"), "Sundering", "Reduced defense.", (MobEffect)new CustomStatusEffect(MobEffectCategory.HARMFUL, 0xFF0000), new EffectConfig(List.of(new AttributeModifier(Attributes.ARMOR.getRegisteredName(), -0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry RAMPAGING = ArsenalEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"rampaging"), "Rampaging", "Increased attack damage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0xFF9900), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_DAMAGE.getRegisteredName(), 0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry FOCUSING = ArsenalEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"focusing"), "Focusing", "Increased ranged attack damage.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0xFF9900), new EffectConfig(List.of(new AttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.id.toString(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry UNYIELDING = ArsenalEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"unyielding"), "Unyielding", "Increased knockback resistance and toughness.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 65280), new EffectConfig(List.of(new AttributeModifier(Attributes.KNOCKBACK_RESISTANCE.getRegisteredName(), 3.0f, AttributeModifier.Operation.ADD_VALUE), new AttributeModifier(Attributes.ARMOR_TOUGHNESS.getRegisteredName(), 0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry SURGING = ArsenalEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"surging"), "Surging", "Increased spell critical chance.", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 65280), new EffectConfig(List.of(new AttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.id.toString(), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static final Effects.Entry ABSORPTION = ArsenalEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"arsenal", (String)"absorption"), "Absorption", "Increases maximum absorption", (MobEffect)new AbsorptionStatusEffect(MobEffectCategory.BENEFICIAL, 0xFFFFCC), new EffectConfig(List.of(new AttributeModifier(Attributes.MAX_ABSORPTION.getRegisteredName(), 2.0f, AttributeModifier.Operation.ADD_VALUE)))));

    private static Effects.Entry add(Effects.Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register(ConfigFile.Effects config) {
        ActionImpairing.configure((MobEffect)ArsenalEffects.STUN.effect, (EntityActionsAllowed)EntityActionsAllowed.STUN);
        for (Effects.Entry entry : entries) {
            Synchronized.configure((MobEffect)entry.effect, (boolean)true);
        }
        Synchronized.configure((MobEffect)((MobEffect)MobEffects.POISON.value()), (boolean)true);
        Effects.register(entries, (Map)config.effects);
    }
}

