/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.village;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabric_extras.structure_pool.api.StructurePoolAPI;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.rogues.RoguesMod;
import net.rogues.block.CustomBlocks;
import net.rogues.item.RogueWeapons;
import net.rogues.item.armor.RogueArmors;
import net.rogues.util.RogueSounds;

public class RogueVillagers {
    public static final String MERCHANT = "arms_merchant";
    public static final ResourceLocation POI_ID = ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)"arms_merchant");

    public static void registerPOI() {
        ImmutableSet blockStates = ImmutableSet.copyOf((Collection)CustomBlocks.WORKBENCH.block().getStateDefinition().getPossibleStates());
        PointOfInterestHelper.register((ResourceLocation)POI_ID, (int)1, (int)10, (Iterable)blockStates);
    }

    public static VillagerProfession registerProfession(String name, ResourceKey<PoiType> workStation) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)name);
        return (VillagerProfession)Registry.register((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)name), (Object)new VillagerProfession(id.toString(), entry -> entry.is(workStation), entry -> entry.is(workStation), ImmutableSet.of(), ImmutableSet.of(), RogueSounds.WORKBENCH.soundEvent()));
    }

    public static void registerVillagers() {
        if (!FabricLoader.getInstance().isModLoaded("lithostitched")) {
            StructurePoolAPI.injectAll((StructurePoolConfig)((StructurePoolConfig)RoguesMod.villagesConfig.value));
        }
        VillagerProfession profession = RogueVillagers.registerProfession(MERCHANT, (ResourceKey<PoiType>)ResourceKey.create((ResourceKey)BuiltInRegistries.POINT_OF_INTEREST_TYPE.key(), (ResourceLocation)POI_ID));
        LinkedHashMap<Integer, List<VillagerTrades.ItemsForEmeralds>> trades = new LinkedHashMap<Integer, List<VillagerTrades.ItemsForEmeralds>>();
        trades.put(1, List.of(new VillagerTrades.EmeraldForItems((ItemLike)Items.LEATHER, 8, 12, 4, 5), new VillagerTrades.ItemsForEmeralds(RogueWeapons.flint_dagger.item(), 6, 1, 12, 3), new VillagerTrades.ItemsForEmeralds(RogueWeapons.stone_double_axe.item(), 8, 1, 12, 4)));
        trades.put(2, List.of(new VillagerTrades.EmeraldForItems((ItemLike)Items.IRON_INGOT, 12, 12, 5, 8), new VillagerTrades.ItemsForEmeralds(RogueWeapons.iron_sickle.item(), 12, 1, 12, 10), new VillagerTrades.ItemsForEmeralds(RogueWeapons.iron_glaive.item(), 18, 1, 12, 10), new VillagerTrades.ItemsForEmeralds((Item)RogueArmors.RogueArmorSet_t1.head, 15, 1, 12, 13), new VillagerTrades.ItemsForEmeralds((Item)RogueArmors.WarriorArmorSet_t1.head, 15, 1, 12, 13)));
        trades.put(3, List.of(new VillagerTrades.ItemsForEmeralds(RogueWeapons.iron_dagger.item(), 14, 1, 12, 15), new VillagerTrades.ItemsForEmeralds(RogueWeapons.iron_double_axe.item(), 18, 1, 12, 15), new VillagerTrades.ItemsForEmeralds((Item)RogueArmors.RogueArmorSet_t1.feet, 15, 1, 12, 15), new VillagerTrades.ItemsForEmeralds((Item)RogueArmors.WarriorArmorSet_t1.feet, 15, 1, 12, 15), new VillagerTrades.ItemsForEmeralds((Item)RogueArmors.RogueArmorSet_t1.legs, 15, 1, 12, 15), new VillagerTrades.ItemsForEmeralds((Item)RogueArmors.WarriorArmorSet_t1.legs, 15, 1, 12, 15)));
        trades.put(4, List.of(new VillagerTrades.ItemsForEmeralds((Item)RogueArmors.RogueArmorSet_t1.chest, 15, 1, 12, 15), new VillagerTrades.ItemsForEmeralds((Item)RogueArmors.WarriorArmorSet_t1.chest, 15, 1, 12, 15), new VillagerTrades.ItemsForEmeralds(Items.GOAT_HORN, 15, 1, 12, 5)));
        for (Map.Entry entry : trades.entrySet()) {
            TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)((Integer)entry.getKey()), factories -> factories.addAll((Collection)entry.getValue()));
        }
        TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)5, factories -> {
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(RogueWeapons.diamond_dagger.item(), 30, 3, 30, 0.0f).getOffer(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(RogueWeapons.diamond_sickle.item(), 30, 3, 30, 0.0f).getOffer(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(RogueWeapons.diamond_double_axe.item(), 40, 3, 30, 0.0f).getOffer(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(RogueWeapons.diamond_glaive.item(), 40, 3, 30, 0.0f).getOffer(entity, random));
        });
    }
}

