/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RogueSounds {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static final Entry SLICE_AND_DICE = RogueSounds.add(new Entry("slice_and_dice"));
    public static final Entry SHOCK_POWDER_RELEASE = RogueSounds.add(new Entry("shock_powder_release"));
    public static final Entry SHOCK_POWDER_IMPACT = RogueSounds.add(new Entry("shock_powder_impact"));
    public static final Entry SHADOW_STEP_ARRIVE = RogueSounds.add(new Entry("shadow_step_arrive"));
    public static final Entry SHADOW_STEP_DEPART = RogueSounds.add(new Entry("shadow_step_depart"));
    public static final Entry VANISH_RELEASE = RogueSounds.add(new Entry("vanish_release"));
    public static final Entry VANISH_COMBINED = RogueSounds.add(new Entry("vanish_combined"));
    public static final Entry THROW = RogueSounds.add(new Entry("throw"));
    public static final Entry THROW_IMPACT = RogueSounds.add(new Entry("throw_impact"));
    public static final Entry SHOUT_RELEASE = RogueSounds.add(new Entry("shout_release"));
    public static final Entry DEMORALIZE_IMPACT = RogueSounds.add(new Entry("demoralize_impact"));
    public static final Entry CHARGE_ACTIVATE = RogueSounds.add(new Entry("charge_activate"));
    public static final Entry WHIRLWIND = RogueSounds.add(new Entry("whirlwind"));
    public static final Entry ROGUE_ARMOR_EQUIP = RogueSounds.add(new Entry("rogue_armor"));
    public static final Entry WARRIOR_ARMOR_EQUIP = RogueSounds.add(new Entry("warrior_armor"));
    public static final Entry WORKBENCH = RogueSounds.add(new Entry("arms_workbench"));
    public static final Entry STEALTH_LEAVE = RogueSounds.add(new Entry("stealth_leave"));

    public static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : entries) {
            entry.entry = Registry.registerForHolder((Registry)BuiltInRegistries.SOUND_EVENT, (ResourceLocation)entry.id(), (Object)entry.soundEvent());
        }
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent) {
        RogueSounds.playSoundEvent(world, entity, soundEvent, 1.0f, 1.0f);
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent, float volume, float pitch) {
        world.playSound((Player)null, entity.getX(), entity.getY(), entity.getZ(), soundEvent, SoundSource.PLAYERS, volume, pitch);
    }

    public static final class Entry {
        private final ResourceLocation id;
        private final SoundEvent soundEvent;
        private Holder<SoundEvent> entry;
        private int variants = 1;

        public Entry(ResourceLocation id, SoundEvent soundEvent) {
            this.id = id;
            this.soundEvent = soundEvent;
        }

        public Entry(String name) {
            this(ResourceLocation.fromNamespaceAndPath((String)"rogues", (String)name));
        }

        public Entry(ResourceLocation id) {
            this(id, SoundEvent.createVariableRangeEvent((ResourceLocation)id));
        }

        public Entry travelDistance(float distance) {
            return new Entry(this.id, SoundEvent.createFixedRangeEvent((ResourceLocation)this.id, (float)distance));
        }

        public Entry variants(int variants) {
            this.variants = variants;
            return this;
        }

        public ResourceLocation id() {
            return this.id;
        }

        public SoundEvent soundEvent() {
            return this.soundEvent;
        }

        public Holder<SoundEvent> entry() {
            return this.entry;
        }

        public int variants() {
            return this.variants;
        }
    }
}

