/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.item;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.rogues.RoguesMod;
import net.rogues.config.TweaksConfig;
import net.rogues.item.Group;
import net.spell_engine.api.config.WeaponConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.weapon.SpellSwordItem;
import net.spell_engine.api.item.weapon.Weapon;

public class RogueWeapons {
    public static final ArrayList<Weapon.Entry> entries = new ArrayList();
    private static final String AETHER = "aether";
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";
    public static final Weapon.Entry flint_dagger = RogueWeapons.dagger("flint_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.FLINT})), 2.6f).loot(Equipment.LootProperties.of((int)0));
    public static final Weapon.Entry iron_dagger = RogueWeapons.dagger("iron_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})), 3.3f).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry golden_dagger = RogueWeapons.dagger("golden_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})), 1.8f).loot(Equipment.LootProperties.of((String)"golden_weapon"));
    public static final Weapon.Entry diamond_dagger = RogueWeapons.dagger("diamond_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND})), 4.0f).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netherite_dagger = RogueWeapons.dagger("netherite_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})), 4.7f).loot(Equipment.LootProperties.of((int)3));
    public static final Weapon.Entry iron_sickle = RogueWeapons.sickle("iron_sickle", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})), 4.1f).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry golden_sickle = RogueWeapons.sickle("golden_sickle", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})), 2.4f).loot(Equipment.LootProperties.of((String)"golden_weapon"));
    public static final Weapon.Entry diamond_sickle = RogueWeapons.sickle("diamond_sickle", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND})), 5.0f).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netherite_sickle = RogueWeapons.sickle("netherite_sickle", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})), 5.9f).loot(Equipment.LootProperties.of((int)3));
    public static final Weapon.Entry stone_double_axe = RogueWeapons.axe("stone_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.STONE, () -> Ingredient.of((TagKey)ItemTags.STONE_TOOL_MATERIALS)), 5.6f).loot(Equipment.LootProperties.of((int)0));
    public static final Weapon.Entry iron_double_axe = RogueWeapons.axe("iron_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})), 7.0f).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry golden_double_axe = RogueWeapons.axe("golden_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})), 4.3f).loot(Equipment.LootProperties.of((String)"golden_weapon"));
    public static final Weapon.Entry diamond_double_axe = RogueWeapons.axe("diamond_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND})), 8.3f).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netherite_double_axe = RogueWeapons.axe("netherite_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})), 9.6f).loot(Equipment.LootProperties.of((int)3));
    public static final Weapon.Entry iron_glaive = RogueWeapons.glaive("iron_glaive", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})), 5.8f).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry golden_glaive = RogueWeapons.glaive("golden_glaive", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})), 3.5f).loot(Equipment.LootProperties.of((String)"golden_weapon"));
    public static final Weapon.Entry diamond_glaive = RogueWeapons.glaive("diamond_glaive", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND})), 7.0f).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netherite_glaive = RogueWeapons.glaive("netherite_glaive", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})), 8.1f).loot(Equipment.LootProperties.of((int)3));

    private static Weapon.Entry entry(String name, Weapon.CustomMaterial material, Weapon.Factory factory, WeaponConfig defaults, Equipment.WeaponType type) {
        Weapon.Entry entry = new Weapon.Entry("rogues", name, material, factory, defaults, type);
        entry.castSpell();
        entries.add(entry);
        return entry;
    }

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = ResourceLocation.parse((String)idString);
        if (requirement) {
            return () -> Ingredient.of((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.of((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    private static Weapon.Entry dagger(String name, Weapon.CustomMaterial material, float damage) {
        return RogueWeapons.entry(name, material, SpellSwordItem::new, new WeaponConfig(damage, -1.6f), Equipment.WeaponType.DAGGER);
    }

    private static Weapon.Entry sickle(String name, Weapon.CustomMaterial material, float damage) {
        return RogueWeapons.entry(name, material, SpellSwordItem::new, new WeaponConfig(damage, -2.0f), Equipment.WeaponType.SICKLE);
    }

    private static Weapon.Entry axe(String name, Weapon.CustomMaterial material, float damage) {
        return RogueWeapons.entry(name, material, SpellSwordItem::new, new WeaponConfig(damage, -2.8f), Equipment.WeaponType.DOUBLE_AXE);
    }

    private static Weapon.Entry glaive(String name, Weapon.CustomMaterial material, float damage) {
        return RogueWeapons.entry(name, material, SpellSwordItem::new, new WeaponConfig(damage, -2.6f), Equipment.WeaponType.GLAIVE);
    }

    public static void register(Map<String, WeaponConfig> configs) {
        Supplier<Ingredient> repair;
        if (((TweaksConfig)RoguesMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_NETHER)) {
            repair = RogueWeapons.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), Items.NETHERITE_INGOT);
            RogueWeapons.dagger("ruby_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 5.5f).loot(Equipment.LootProperties.of((int)4));
            RogueWeapons.sickle("ruby_sickle", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 6.8f).loot(Equipment.LootProperties.of((int)4));
            RogueWeapons.axe("ruby_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 11.0f).loot(Equipment.LootProperties.of((int)4));
            RogueWeapons.glaive("ruby_glaive", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 9.3f).loot(Equipment.LootProperties.of((int)4));
        }
        if (((TweaksConfig)RoguesMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_END)) {
            repair = RogueWeapons.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded(BETTER_END), Items.NETHERITE_INGOT);
            RogueWeapons.dagger("aeternium_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 5.5f).loot(Equipment.LootProperties.of((int)4));
            RogueWeapons.sickle("aeternium_sickle", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 6.8f).loot(Equipment.LootProperties.of((int)4));
            RogueWeapons.axe("aeternium_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 11.0f).loot(Equipment.LootProperties.of((int)4));
            RogueWeapons.glaive("aeternium_glaive", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 9.3f).loot(Equipment.LootProperties.of((int)4));
        }
        if (((TweaksConfig)RoguesMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(AETHER)) {
            repair = RogueWeapons.ingredient("aether:ambrosium_shard", FabricLoader.getInstance().isModLoaded(AETHER), Items.NETHERITE_INGOT);
            RogueWeapons.dagger("aether_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 5.5f).loot(Equipment.LootProperties.of((String)AETHER));
            RogueWeapons.sickle("aether_sickle", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 6.8f).loot(Equipment.LootProperties.of((String)AETHER));
            RogueWeapons.axe("aether_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 11.0f).loot(Equipment.LootProperties.of((String)AETHER));
            RogueWeapons.glaive("aether_glaive", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 9.3f).loot(Equipment.LootProperties.of((String)AETHER));
        }
        Weapon.register(configs, entries, Group.KEY);
    }
}

