/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabric_extras.ranged_weapon.api.AttributeModifierIDs;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class AttributeUtils {
    public static ItemAttributeModifiers mergeComponents(ItemAttributeModifiers target, ItemAttributeModifiers source) {
        if (source == null && target == null) {
            return null;
        }
        if (source == null) {
            return target;
        }
        if (target == null) {
            return source;
        }
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        for (ItemAttributeModifiers.Entry entry : source.modifiers()) {
            builder.add(entry.attribute(), entry.modifier(), entry.slot());
        }
        for (ItemAttributeModifiers.Entry entry : target.modifiers()) {
            builder.add(entry.attribute(), entry.modifier(), entry.slot());
        }
        return builder.build();
    }

    public static ItemAttributeModifiers fromRangedConfig(RangedConfig config) {
        EquipmentSlotGroup slot = EquipmentSlotGroup.HAND;
        AttributeModifier damage = new AttributeModifier(AttributeModifierIDs.WEAPON_DAMAGE_ID, (double)config.damage(), AttributeModifier.Operation.ADD_VALUE);
        AttributeModifier pullTime = new AttributeModifier(AttributeModifierIDs.WEAPON_PULL_TIME_ID, (double)config.pull_time_bonus(), AttributeModifier.Operation.ADD_VALUE);
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder().add(EntityAttributes_RangedWeapon.DAMAGE.entry, damage, slot).add(EntityAttributes_RangedWeapon.PULL_TIME.entry, pullTime, slot);
        if (config.velocity_bonus() > 0.0f) {
            AttributeModifier velocity = new AttributeModifier(AttributeModifierIDs.WEAPON_VELOCITY_ID, (double)config.velocity_bonus(), AttributeModifier.Operation.ADD_VALUE);
            builder.add(EntityAttributes_RangedWeapon.VELOCITY.entry, velocity, slot);
        }
        for (ComponentEntry entry : AttributeUtils.componentEntriesFrom(config.attributes(), slot)) {
            builder.add(entry.attribute, entry.modifier, entry.slot);
        }
        return builder.build();
    }

    public static List<ComponentEntry> componentEntriesFrom(List<RangedConfig.Attribute> attributes, EquipmentSlotGroup slot) {
        ArrayList<ComponentEntry> list = new ArrayList<ComponentEntry>();
        if (attributes == null || attributes.isEmpty()) {
            return list;
        }
        for (RangedConfig.Attribute attr : attributes) {
            ResourceLocation modifierId;
            ResourceLocation entityAttributeId;
            try {
                entityAttributeId = ResourceLocation.tryParse((String)attr.attributeId());
            }
            catch (Exception e) {
                continue;
            }
            Optional entityAttribute = BuiltInRegistries.ATTRIBUTE.getHolder(entityAttributeId);
            if (entityAttribute.isEmpty() || attr.modifier() == null) continue;
            try {
                modifierId = ResourceLocation.tryParse((String)attr.modifier().modifierId());
            }
            catch (Exception e) {
                continue;
            }
            list.add(new ComponentEntry((Holder<Attribute>)((Holder)entityAttribute.get()), new AttributeModifier(modifierId, attr.modifier().value(), attr.modifier().operation()), slot));
        }
        return list;
    }

    public record ComponentEntry(Holder<Attribute> attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
    }
}

