/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.api;

import java.util.ArrayList;
import net.fabric_extras.ranged_weapon.Platform;
import net.fabric_extras.ranged_weapon.api.AttributeModifierIDs;
import net.fabric_extras.ranged_weapon.internal.NeoAttribute;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import org.jetbrains.annotations.Nullable;

public class EntityAttributes_RangedWeapon {
    public static final String NAMESPACE = "ranged_weapon";
    public static final ArrayList<Entry> all = new ArrayList();
    public static final Entry DAMAGE = EntityAttributes_RangedWeapon.entry("damage", 0.0, true).setBaseAttributeId(AttributeModifierIDs.WEAPON_DAMAGE_ID);
    public static final Entry PULL_TIME = EntityAttributes_RangedWeapon.entry("pull_time", 0.1, 1.0, true).setBaseAttributeId(AttributeModifierIDs.WEAPON_PULL_TIME_ID);
    public static final Entry HASTE = EntityAttributes_RangedWeapon.entry("haste", 100.0, true);
    public static final Entry VELOCITY = EntityAttributes_RangedWeapon.entry("velocity", 0.0, false);

    private static Entry entry(String name, double baseValue, boolean tracked) {
        return EntityAttributes_RangedWeapon.entry(name, 0.0, baseValue, tracked);
    }

    private static Entry entry(String name, double minValue, double baseValue, boolean tracked) {
        Entry entry = new Entry(name, minValue, baseValue, tracked);
        all.add(entry);
        return entry;
    }

    public static class Entry {
        public final ResourceLocation id;
        public final String translationKey;
        public final Attribute attribute;
        public final double baseValue;
        @Nullable
        public Holder<Attribute> entry;

        public Entry(String name, double minValue, double baseValue, boolean tracked) {
            this.id = ResourceLocation.fromNamespaceAndPath((String)EntityAttributes_RangedWeapon.NAMESPACE, (String)name);
            this.translationKey = "attribute.name.ranged_weapon." + name;
            this.attribute = Platform.util().makeAttribute(this.translationKey, baseValue, minValue, 2048.0).setSyncable(tracked);
            this.baseValue = baseValue;
        }

        public double asMultiplier(double attributeValue) {
            return attributeValue / this.baseValue;
        }

        public void register() {
            this.entry = Registry.registerForHolder((Registry)BuiltInRegistries.ATTRIBUTE, (ResourceLocation)this.id, (Object)this.attribute);
        }

        public Entry setBaseAttributeId(ResourceLocation id) {
            Attribute attribute = this.attribute;
            if (attribute instanceof NeoAttribute) {
                NeoAttribute neo = (NeoAttribute)attribute;
                neo.setBaseModifierId(id);
            }
            return this;
        }
    }
}

