/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftbessentials.util.DimensionFilter;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class TeleportPos {
    private final ResourceKey<Level> dimension;
    private final BlockPos pos;
    public final Float yRot;
    public final Float xRot;
    private final long time;

    public TeleportPos(ResourceKey<Level> d, BlockPos p) {
        this(d, p, null, null);
    }

    public TeleportPos(ResourceKey<Level> d, BlockPos p, Float yRot, Float xRot) {
        this.dimension = d;
        this.pos = p;
        this.yRot = yRot;
        this.xRot = xRot;
        this.time = System.currentTimeMillis();
    }

    public TeleportPos(Level world, BlockPos p, Float yRot, Float xRot) {
        this((ResourceKey<Level>)world.dimension(), p, yRot, xRot);
    }

    public TeleportPos(Entity entity) {
        this(entity.level(), entity.blockPosition(), Float.valueOf(entity.getYRot()), Float.valueOf(entity.getXRot()));
    }

    public TeleportPos(CompoundTag tag) {
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.tryParse((String)tag.getString("dim")));
        this.pos = new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
        this.yRot = tag.getTagType("yRot") == 5 ? Float.valueOf(tag.getFloat("yRot")) : null;
        this.xRot = tag.getTagType("xRot") == 5 ? Float.valueOf(tag.getFloat("xRot")) : null;
        this.time = tag.getLong("time");
    }

    public TeleportPos safeForPlayer(ServerPlayer player) {
        ServerLevel level = player.getServer().getLevel(this.dimension);
        if (level == null) {
            return this;
        }
        return this.tryFindSafePos(level, Direction.NORTH, Direction.WEST).or(() -> this.tryFindSafePos(level, Direction.SOUTH, Direction.EAST)).orElse(this);
    }

    private Optional<TeleportPos> tryFindSafePos(ServerLevel level, Direction dir1, Direction dir2) {
        for (BlockPos p0 : BlockPos.spiralAround((BlockPos)this.pos, (int)16, (Direction)dir1, (Direction)dir2)) {
            for (int yOff = -3; yOff <= 3; ++yOff) {
                BlockPos p1 = p0.relative(Direction.Axis.Y, yOff);
                BlockPos p2 = p1.above();
                if (level.getBlockState(p1).isSuffocating((BlockGetter)level, p1) || level.getBlockState(p2).isSuffocating((BlockGetter)level, p2)) continue;
                return Optional.of(new TeleportPos(this.dimension, p1.immutable(), this.yRot, this.xRot));
            }
        }
        return Optional.empty();
    }

    public TeleportResult checkDimensionBlacklist(Player player) {
        if (!DimensionFilter.isDimensionOKTo(this.dimension)) {
            return TeleportResult.DIMENSION_NOT_ALLOWED_TO;
        }
        if (!DimensionFilter.isDimensionOKFrom((ResourceKey<Level>)player.level().dimension())) {
            return TeleportResult.DIMENSION_NOT_ALLOWED_FROM;
        }
        return TeleportResult.SUCCESS;
    }

    public TeleportResult teleport(ServerPlayer player) {
        ServerLevel level = player.server.getLevel(this.dimension);
        if (level == null) {
            return TeleportResult.DIMENSION_NOT_FOUND;
        }
        int xpLevel = player.experienceLevel;
        float xrot = this.xRot == null ? player.getXRot() : this.xRot.floatValue();
        float yrot = this.yRot == null ? player.getYRot() : this.yRot.floatValue();
        player.teleportTo(level, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.1, (double)this.pos.getZ() + 0.5, yrot, xrot);
        player.setExperienceLevels(xpLevel);
        return TeleportResult.SUCCESS;
    }

    public CompoundTag write() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.singleLine();
        tag.putString("dim", this.dimension.location().toString());
        tag.putInt("x", this.pos.getX());
        tag.putInt("y", this.pos.getY());
        tag.putInt("z", this.pos.getZ());
        tag.putLong("time", this.time);
        if (this.xRot != null) {
            tag.putFloat("xRot", this.xRot.floatValue());
        }
        if (this.yRot != null) {
            tag.putFloat("yRot", this.yRot.floatValue());
        }
        return tag;
    }

    public String distanceString(TeleportPos origin) {
        if (origin.dimension == this.dimension) {
            double dx = this.pos.getX() - origin.pos.getX();
            double dz = this.pos.getZ() - origin.pos.getZ();
            return (int)Math.sqrt(dx * dx + dz * dz) + "m";
        }
        ResourceLocation s = this.dimension.location();
        if (s.getNamespace().equals("minecraft")) {
            return switch (s.getPath()) {
                case "overworld" -> "Overworld";
                case "the_nether" -> "The Nether";
                case "the_end" -> "The End";
                default -> s.getPath();
            };
        }
        return s.getPath() + " [" + s.getNamespace() + "]";
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String posAsString() {
        return this.pos.toShortString().replaceAll(",", "");
    }

    @FunctionalInterface
    public static interface TeleportResult {
        public static final TeleportResult SUCCESS = new TeleportResult(){

            @Override
            public int runCommand(ServerPlayer player) {
                return 1;
            }

            @Override
            public boolean isSuccess() {
                return true;
            }
        };
        public static final TeleportResult DIMENSION_NOT_FOUND = TeleportResult.failed((Component)Component.translatable((String)"ftbessentials.dimension_not_found"));
        public static final TeleportResult UNKNOWN_DESTINATION = TeleportResult.failed((Component)Component.translatable((String)"ftbessentials.unknown_dest"));
        public static final TeleportResult DIMENSION_NOT_ALLOWED_FROM = TeleportResult.failed((Component)Component.translatable((String)"ftbessentials.teleport.not_from_here"));
        public static final TeleportResult DIMENSION_NOT_ALLOWED_TO = TeleportResult.failed((Component)Component.translatable((String)"ftbessentials.teleport.not_to_here"));

        public static TeleportResult failed(Component msg) {
            return player -> {
                player.displayClientMessage(msg, false);
                return 0;
            };
        }

        public int runCommand(ServerPlayer var1);

        default public boolean isSuccess() {
            return false;
        }
    }

    @FunctionalInterface
    public static interface CooldownTeleportResult
    extends TeleportResult {
        public long getCooldown();

        @Override
        default public int runCommand(ServerPlayer player) {
            String secStr = TimeUtils.prettyTimeString((long)(this.getCooldown() / 1000L));
            player.displayClientMessage((Component)Component.translatable((String)"ftbessentials.teleport.on_cooldown", (Object[])new Object[]{secStr}), false);
            return 0;
        }
    }
}

