/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.compat;

import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.util.Threads;
import dynamic_fps.impl.util.Version;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;

public class GLFW {
    private static final boolean enterEventBroken = GLFW.isEnterEventBroken();

    public static void applyWorkaround() {
        Minecraft minecraft = Minecraft.getInstance();
        if (!GLFW.useWorkaround()) {
            return;
        }
        if (DynamicFPSMod.getWindow() == null) {
            return;
        }
        if (!DynamicFPSMod.getWindow().isFocused()) {
            minecraft.mouseHandler.releaseMouse();
        } else {
            Threads.runOnMainThread(() -> ((MouseHandler)minecraft.mouseHandler).grabMouse());
        }
    }

    private static boolean useWorkaround() {
        Minecraft minecraft = Minecraft.getInstance();
        return enterEventBroken && minecraft.screen == null && !minecraft.options.pauseOnLostFocus;
    }

    private static boolean isEnterEventBroken() {
        Version active = GLFW.getGLFWVersion();
        return active.compareTo(Version.of(3, 3, 0)) < 0;
    }

    private static Version getGLFWVersion() {
        int[] major = new int[1];
        int[] minor = new int[1];
        int[] patch = new int[1];
        org.lwjgl.glfw.GLFW.glfwGetVersion((int[])major, (int[])minor, (int[])patch);
        return Version.of(major[0], minor[0], patch[0]);
    }
}

